/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.plain.SortedOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.DelegateDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;

public class TimeSeriesRoutingHashFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_ts_routing_hash";
    public static final TimeSeriesRoutingHashFieldMapper INSTANCE = new TimeSeriesRoutingHashFieldMapper();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> c.getIndexSettings().getMode().timeSeriesRoutingHashFieldMapper());
    public static final DocValueFormat TS_ROUTING_HASH_DOC_VALUE_FORMAT = TimeSeriesRoutingHashFieldType.DOC_VALUE_FORMAT;
    public static final String DUMMY_ENCODED_VALUE = TimeSeriesRoutingHashFieldMapper.encode(0);

    private TimeSeriesRoutingHashFieldMapper() {
        super(TimeSeriesRoutingHashFieldType.INSTANCE);
    }

    @Override
    public void postParse(DocumentParserContext context) {
        if (context.indexSettings().getMode() == IndexMode.TIME_SERIES && context.indexSettings().getIndexVersionCreated().onOrAfter(IndexVersions.TIME_SERIES_ROUTING_HASH_IN_ID)) {
            String routingHash = context.sourceToParse().routing();
            if (routingHash == null) {
                assert (context.sourceToParse().id() != null);
                routingHash = Strings.BASE_64_NO_PADDING_URL_ENCODER.encodeToString(Arrays.copyOf(Base64.getUrlDecoder().decode(context.sourceToParse().id()), 4));
            }
            SortedDocValuesField field = new SortedDocValuesField(NAME, Uid.encodeId(routingHash));
            context.rootDoc().add((IndexableField)field);
        }
    }

    @Override
    protected String contentType() {
        return NAME;
    }

    public static String encode(int routingId) {
        byte[] bytes = new byte[4];
        ByteUtils.writeIntLE(routingId, bytes, 0);
        return Strings.BASE_64_NO_PADDING_URL_ENCODER.encodeToString(bytes);
    }

    public static int decode(String routingId) {
        byte[] bytes = Base64.getUrlDecoder().decode(routingId);
        return ByteUtils.readIntLE(bytes, 0);
    }

    static final class TimeSeriesRoutingHashFieldType
    extends MappedFieldType {
        private static final TimeSeriesRoutingHashFieldType INSTANCE = new TimeSeriesRoutingHashFieldType();
        static final DocValueFormat DOC_VALUE_FORMAT = new DocValueFormat(){

            @Override
            public String getWriteableName() {
                return TimeSeriesRoutingHashFieldMapper.NAME;
            }

            @Override
            public void writeTo(StreamOutput out) {
            }

            @Override
            public Object format(BytesRef value) {
                return Uid.decodeId(value.bytes, value.offset, value.length);
            }

            @Override
            public BytesRef parseBytesRef(Object value) {
                if (value instanceof BytesRef) {
                    BytesRef valueAsBytesRef = (BytesRef)value;
                    return valueAsBytesRef;
                }
                return Uid.encodeId(value.toString());
            }
        };

        private TimeSeriesRoutingHashFieldType() {
            super(TimeSeriesRoutingHashFieldMapper.NAME, false, false, true, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return TimeSeriesRoutingHashFieldMapper.NAME;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new DocValueFetcher(this.docValueFormat(format, null), (IndexFieldData<?>)context.getForField(this, MappedFieldType.FielddataOperation.SEARCH));
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new SortedOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.KEYWORD, (dv, n) -> new DelegateDocValuesField(new ScriptDocValues.Strings(new ScriptDocValues.StringsSupplier(FieldData.toString(dv))), n));
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("[_ts_routing_hash] is not searchable");
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return DOC_VALUE_FORMAT;
        }
    }
}

