/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record DesiredBalanceStats(long lastConvergedIndex, boolean computationActive, long computationSubmitted, long computationExecuted, long computationConverged, long computationIterations, long computedShardMovements, long cumulativeComputationTime, long cumulativeReconciliationTime, long unassignedShards, long totalAllocations, long undesiredAllocations) implements Writeable,
ToXContentObject
{
    public DesiredBalanceStats {
        if (lastConvergedIndex < 0L) {
            assert (false) : lastConvergedIndex;
            throw new IllegalStateException("lastConvergedIndex must be nonnegative, but got [" + lastConvergedIndex + "]");
        }
    }

    public static DesiredBalanceStats readFrom(StreamInput in) throws IOException {
        return new DesiredBalanceStats(in.readVLong(), in.readBoolean(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readVLong() : -1L, in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readVLong() : -1L, in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readVLong() : -1L);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.lastConvergedIndex);
        out.writeBoolean(this.computationActive);
        out.writeVLong(this.computationSubmitted);
        out.writeVLong(this.computationExecuted);
        out.writeVLong(this.computationConverged);
        out.writeVLong(this.computationIterations);
        out.writeVLong(this.computedShardMovements);
        out.writeVLong(this.cumulativeComputationTime);
        out.writeVLong(this.cumulativeReconciliationTime);
        out.writeVLong(this.unassignedShards);
        out.writeVLong(this.totalAllocations);
        out.writeVLong(this.undesiredAllocations);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("computation_converged_index", this.lastConvergedIndex);
        builder.field("computation_active", this.computationActive);
        builder.field("computation_submitted", this.computationSubmitted);
        builder.field("computation_executed", this.computationExecuted);
        builder.field("computation_converged", this.computationConverged);
        builder.field("computation_iterations", this.computationIterations);
        builder.field("computed_shard_movements", this.computedShardMovements);
        builder.humanReadableField("computation_time_in_millis", "computation_time", (Object)new TimeValue(this.cumulativeComputationTime));
        builder.humanReadableField("reconciliation_time_in_millis", "reconciliation_time", (Object)new TimeValue(this.cumulativeReconciliationTime));
        builder.field("unassigned_shards", this.unassignedShards);
        builder.field("total_allocations", this.totalAllocations);
        builder.field("undesired_allocations", this.undesiredAllocations);
        builder.field("undesired_allocations_ratio", this.undesiredAllocationsRatio());
        builder.endObject();
        return builder;
    }

    public double undesiredAllocationsRatio() {
        if (this.unassignedShards == -1L || this.totalAllocations == -1L || this.undesiredAllocations == -1L) {
            return -1.0;
        }
        if (this.totalAllocations == 0L) {
            return 0.0;
        }
        return (double)this.undesiredAllocations / (double)this.totalAllocations;
    }
}

