/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.project;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.NamedDiffable;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ProjectStateRegistry
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom,
NamedDiffable<ClusterState.Custom> {
    public static final String TYPE = "projects_registry";
    public static final ProjectStateRegistry EMPTY = new ProjectStateRegistry(Collections.emptyMap(), Collections.emptySet(), 0L);
    private static final Entry EMPTY_ENTRY = new Entry(Settings.EMPTY, ImmutableOpenMap.of());
    private static final TransportVersion CLUSTER_STATE_PROJECTS_SETTINGS = TransportVersion.fromName("cluster_state_projects_settings");
    private static final TransportVersion PROJECT_STATE_REGISTRY_RECORDS_DELETIONS = TransportVersion.fromName("project_state_registry_records_deletions");
    private static final TransportVersion PROJECT_STATE_REGISTRY_ENTRY = TransportVersion.fromName("project_state_registry_entry");
    private static final TransportVersion PROJECT_RESERVED_STATE_MOVE_TO_REGISTRY = TransportVersion.fromName("project_reserved_state_move_to_registry");
    public static final DiffableUtils.DiffableValueReader<String, ReservedStateMetadata> RESERVED_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(ReservedStateMetadata::readFrom, ReservedStateMetadata::readDiffFrom);
    private final Map<ProjectId, Entry> projectsEntries;
    private final Set<ProjectId> projectsMarkedForDeletion;
    private final long projectsMarkedForDeletionGeneration;

    public static ProjectStateRegistry get(ClusterState clusterState) {
        return clusterState.custom(TYPE, EMPTY);
    }

    public ProjectStateRegistry(StreamInput in) throws IOException {
        if (in.getTransportVersion().supports(PROJECT_STATE_REGISTRY_ENTRY)) {
            this.projectsEntries = in.readMap(ProjectId::readFrom, Entry::readFrom);
        } else {
            Map<ProjectId, Settings> settingsMap = in.readMap(ProjectId::readFrom, Settings::readSettingsFromStream);
            this.projectsEntries = settingsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Entry((Settings)e.getValue(), ImmutableOpenMap.of())));
        }
        if (in.getTransportVersion().supports(PROJECT_STATE_REGISTRY_RECORDS_DELETIONS)) {
            this.projectsMarkedForDeletion = in.readCollectionAsImmutableSet(ProjectId::readFrom);
            this.projectsMarkedForDeletionGeneration = in.readVLong();
        } else {
            this.projectsMarkedForDeletion = Collections.emptySet();
            this.projectsMarkedForDeletionGeneration = 0L;
        }
    }

    private ProjectStateRegistry(Map<ProjectId, Entry> projectEntries, Set<ProjectId> projectsMarkedForDeletion, long projectsMarkedForDeletionGeneration) {
        this.projectsEntries = projectEntries;
        this.projectsMarkedForDeletion = projectsMarkedForDeletion;
        this.projectsMarkedForDeletionGeneration = projectsMarkedForDeletionGeneration;
    }

    public boolean hasProject(ProjectId projectId) {
        return this.projectsEntries.containsKey(projectId);
    }

    public static Settings getProjectSettings(ProjectId projectId, ClusterState clusterState) {
        ProjectStateRegistry registry = clusterState.custom(TYPE, EMPTY);
        return registry.getProjectSettings(projectId);
    }

    public Settings getProjectSettings(ProjectId projectId) {
        return this.projectsEntries.getOrDefault((Object)projectId, (Entry)ProjectStateRegistry.EMPTY_ENTRY).settings;
    }

    public Map<String, ReservedStateMetadata> reservedStateMetadata(ProjectId projectId) {
        return this.projectsEntries.getOrDefault((Object)projectId, (Entry)ProjectStateRegistry.EMPTY_ENTRY).reservedStateMetadata;
    }

    public Set<ProjectId> getProjectsMarkedForDeletion() {
        return this.projectsMarkedForDeletion;
    }

    public boolean isProjectMarkedForDeletion(ProjectId projectId) {
        return this.projectsMarkedForDeletion.contains(projectId);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        boolean multiProject = params.paramAsBoolean("multi-project", false);
        if (!multiProject) {
            return Collections.emptyIterator();
        }
        return Iterators.concat(Iterators.single((builder, p) -> builder.startArray("projects")), Iterators.map(this.projectsEntries.entrySet().iterator(), entry -> (builder, p) -> {
            builder.startObject();
            builder.field("id", (ToXContent)entry.getKey());
            ((Entry)entry.getValue()).toXContent(builder, params);
            builder.field("marked_for_deletion", this.projectsMarkedForDeletion.contains(entry.getKey()));
            return builder.endObject();
        }), Iterators.single((builder, p) -> builder.endArray()), Iterators.single((builder, p) -> builder.field("projects_marked_for_deletion_generation", this.projectsMarkedForDeletionGeneration)));
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        if (in.getTransportVersion().supports(PROJECT_STATE_REGISTRY_ENTRY)) {
            return new ProjectStateRegistryDiff(in);
        }
        return ProjectStateRegistry.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    @Override
    public Diff<ClusterState.Custom> diff(ClusterState.Custom previousState) {
        if (this.equals(previousState)) {
            return SimpleDiffable.empty();
        }
        return new ProjectStateRegistryDiff((ProjectStateRegistry)previousState, this);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return CLUSTER_STATE_PROJECTS_SETTINGS;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(PROJECT_STATE_REGISTRY_ENTRY)) {
            out.writeMap(this.projectsEntries);
        } else {
            Map<ProjectId, Settings> settingsMap = this.projectsEntries.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Entry)e.getValue()).settings()));
            out.writeMap(settingsMap);
        }
        if (out.getTransportVersion().supports(PROJECT_STATE_REGISTRY_RECORDS_DELETIONS)) {
            out.writeCollection(this.projectsMarkedForDeletion);
            out.writeVLong(this.projectsMarkedForDeletionGeneration);
        } else {
            assert (this.projectsMarkedForDeletion.isEmpty());
            assert (this.projectsMarkedForDeletionGeneration == 0L);
        }
    }

    public int size() {
        return this.projectsEntries.size();
    }

    public long getProjectsMarkedForDeletionGeneration() {
        return this.projectsMarkedForDeletionGeneration;
    }

    public Set<ProjectId> knownProjects() {
        return this.projectsEntries.keySet();
    }

    public String toString() {
        return "ProjectStateRegistry[entities=" + String.valueOf(this.projectsEntries) + ", projectsMarkedForDeletion=" + String.valueOf(this.projectsMarkedForDeletion) + ", projectsMarkedForDeletionGeneration=" + this.projectsMarkedForDeletionGeneration + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectStateRegistry)) {
            return false;
        }
        ProjectStateRegistry that = (ProjectStateRegistry)o;
        return this.projectsMarkedForDeletionGeneration == that.projectsMarkedForDeletionGeneration && Objects.equals(this.projectsEntries, that.projectsEntries) && Objects.equals(this.projectsMarkedForDeletion, that.projectsMarkedForDeletion);
    }

    public int hashCode() {
        return Objects.hash(this.projectsEntries, this.projectsMarkedForDeletion, this.projectsMarkedForDeletionGeneration);
    }

    public static Builder builder(ClusterState original) {
        ProjectStateRegistry projectRegistry = original.custom(TYPE, EMPTY);
        return ProjectStateRegistry.builder(projectRegistry);
    }

    public static Builder builder(ProjectStateRegistry projectRegistry) {
        return new Builder(projectRegistry);
    }

    public static Builder builder() {
        return new Builder();
    }

    private record Entry(Settings settings, ImmutableOpenMap<String, ReservedStateMetadata> reservedStateMetadata) implements ToXContentFragment,
    Writeable,
    Diffable<Entry>
    {
        Entry() {
            this(Settings.EMPTY, ImmutableOpenMap.of());
        }

        public static Entry readFrom(StreamInput in) throws IOException {
            ImmutableOpenMap<String, ReservedStateMetadata> reservedStateMetadata;
            Settings settings = Settings.readSettingsFromStream(in);
            if (in.getTransportVersion().supports(PROJECT_RESERVED_STATE_MOVE_TO_REGISTRY)) {
                int reservedStateSize = in.readVInt();
                ImmutableOpenMap.Builder<String, ReservedStateMetadata> builder = ImmutableOpenMap.builder(reservedStateSize);
                for (int i = 0; i < reservedStateSize; ++i) {
                    ReservedStateMetadata r = ReservedStateMetadata.readFrom(in);
                    builder.put(r.namespace(), r);
                }
                reservedStateMetadata = builder.build();
            } else {
                reservedStateMetadata = ImmutableOpenMap.of();
            }
            return new Entry(settings, reservedStateMetadata);
        }

        public Entry withSettings(Settings settings) {
            return new Entry(settings, this.reservedStateMetadata);
        }

        public Entry withReservedStateMetadata(ReservedStateMetadata reservedStateMetadata) {
            ImmutableOpenMap<String, ReservedStateMetadata> reservedStateMetadataMap = ImmutableOpenMap.builder(this.reservedStateMetadata).fPut(reservedStateMetadata.namespace(), reservedStateMetadata).build();
            return new Entry(this.settings, reservedStateMetadataMap);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeWriteable(this.settings);
            if (out.getTransportVersion().supports(PROJECT_RESERVED_STATE_MOVE_TO_REGISTRY)) {
                out.writeCollection(this.reservedStateMetadata.values());
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("settings");
            this.settings.toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
            builder.endObject();
            builder.startObject("reserved_state");
            for (ReservedStateMetadata reservedStateMetadata : this.reservedStateMetadata.values()) {
                reservedStateMetadata.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public Diff<Entry> diff(Entry previousState) {
            if (this == previousState) {
                return SimpleDiffable.empty();
            }
            return new EntryDiff(this.settings.diff(previousState.settings), DiffableUtils.diff(previousState.reservedStateMetadata, this.reservedStateMetadata, DiffableUtils.getStringKeySerializer()));
        }

        private record EntryDiff(Diff<Settings> settingsDiff, DiffableUtils.MapDiff<String, ReservedStateMetadata, ImmutableOpenMap<String, ReservedStateMetadata>> reservedStateMetadata) implements Diff<Entry>
        {
            public static EntryDiff readFrom(StreamInput in) throws IOException {
                Diff<Settings> settingsDiff = Settings.readSettingsDiffFromStream(in);
                DiffableUtils.MapDiff<String, ReservedStateMetadata, ImmutableOpenMap<String, ReservedStateMetadata>> reservedStateMetadata = in.getTransportVersion().supports(PROJECT_RESERVED_STATE_MOVE_TO_REGISTRY) ? DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), RESERVED_DIFF_VALUE_READER) : DiffableUtils.emptyDiff();
                return new EntryDiff(settingsDiff, reservedStateMetadata);
            }

            @Override
            public Entry apply(Entry part) {
                return new Entry(this.settingsDiff.apply(part.settings), this.reservedStateMetadata.apply(part.reservedStateMetadata));
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeWriteable(this.settingsDiff);
                if (out.getTransportVersion().supports(PROJECT_RESERVED_STATE_MOVE_TO_REGISTRY)) {
                    this.reservedStateMetadata.writeTo(out);
                }
            }
        }
    }

    static class ProjectStateRegistryDiff
    implements NamedDiff<ClusterState.Custom> {
        private static final DiffableUtils.DiffableValueReader<ProjectId, Entry> VALUE_READER = new DiffableUtils.DiffableValueReader(Entry::readFrom, Entry.EntryDiff::readFrom);
        private static final TransportVersion PROJECT_STATE_REGISTRY_ENTRY = TransportVersion.fromName("project_state_registry_entry");
        private final DiffableUtils.MapDiff<ProjectId, Entry, Map<ProjectId, Entry>> projectsEntriesDiff;
        private final Set<ProjectId> projectsMarkedForDeletion;
        private final long projectsMarkedForDeletionGeneration;

        ProjectStateRegistryDiff(StreamInput in) throws IOException {
            this.projectsEntriesDiff = DiffableUtils.readJdkMapDiff(in, ProjectId.PROJECT_ID_SERIALIZER, VALUE_READER);
            this.projectsMarkedForDeletion = in.readCollectionAsImmutableSet(ProjectId.READER);
            this.projectsMarkedForDeletionGeneration = in.readVLong();
        }

        ProjectStateRegistryDiff(ProjectStateRegistry previousState, ProjectStateRegistry currentState) {
            this.projectsEntriesDiff = DiffableUtils.diff(previousState.projectsEntries, currentState.projectsEntries, ProjectId.PROJECT_ID_SERIALIZER, VALUE_READER);
            this.projectsMarkedForDeletion = currentState.projectsMarkedForDeletion;
            this.projectsMarkedForDeletionGeneration = currentState.projectsMarkedForDeletionGeneration;
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return PROJECT_STATE_REGISTRY_ENTRY;
        }

        @Override
        public ClusterState.Custom apply(ClusterState.Custom part) {
            return new ProjectStateRegistry(this.projectsEntriesDiff.apply(((ProjectStateRegistry)part).projectsEntries), this.projectsMarkedForDeletion, this.projectsMarkedForDeletionGeneration);
        }

        @Override
        public String getWriteableName() {
            return ProjectStateRegistry.TYPE;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.projectsEntriesDiff.writeTo(out);
            out.writeCollection(this.projectsMarkedForDeletion);
            out.writeVLong(this.projectsMarkedForDeletionGeneration);
        }
    }

    public static class Builder {
        private final ImmutableOpenMap.Builder<ProjectId, Entry> projectsEntries;
        private final Set<ProjectId> projectsMarkedForDeletion;
        private final long projectsMarkedForDeletionGeneration;
        private boolean newProjectMarkedForDeletion = false;

        private Builder() {
            this.projectsEntries = ImmutableOpenMap.builder();
            this.projectsMarkedForDeletion = new HashSet<ProjectId>();
            this.projectsMarkedForDeletionGeneration = 0L;
        }

        private Builder(ProjectStateRegistry original) {
            this.projectsEntries = ImmutableOpenMap.builder(original.projectsEntries);
            this.projectsMarkedForDeletion = new HashSet<ProjectId>(original.projectsMarkedForDeletion);
            this.projectsMarkedForDeletionGeneration = original.projectsMarkedForDeletionGeneration;
        }

        private void updateEntry(ProjectId projectId, UnaryOperator<Entry> modifier) {
            Entry entry = this.projectsEntries.get(projectId);
            if (entry == null) {
                entry = new Entry();
            }
            entry = (Entry)modifier.apply(entry);
            this.projectsEntries.put(projectId, entry);
        }

        public Builder putProjectSettings(ProjectId projectId, Settings settings) {
            this.updateEntry(projectId, entry -> entry.withSettings(settings));
            return this;
        }

        public Builder putReservedStateMetadata(ProjectId projectId, ReservedStateMetadata reservedStateMetadata) {
            this.updateEntry(projectId, entry -> entry.withReservedStateMetadata(reservedStateMetadata));
            return this;
        }

        public Builder markProjectForDeletion(ProjectId projectId) {
            if (this.projectsMarkedForDeletion.add(projectId)) {
                this.newProjectMarkedForDeletion = true;
            }
            return this;
        }

        public Builder removeProject(ProjectId projectId) {
            this.projectsEntries.remove(projectId);
            this.projectsMarkedForDeletion.remove(projectId);
            return this;
        }

        public ProjectStateRegistry build() {
            Set<ProjectId> unknownButUnderDeletion = Sets.difference(this.projectsMarkedForDeletion, this.projectsEntries.keys());
            if (!unknownButUnderDeletion.isEmpty()) {
                throw new IllegalArgumentException("Cannot mark projects for deletion that are not in the registry: " + String.valueOf(unknownButUnderDeletion));
            }
            return new ProjectStateRegistry(this.projectsEntries.build(), Collections.unmodifiableSet(this.projectsMarkedForDeletion), this.newProjectMarkedForDeletion ? this.projectsMarkedForDeletionGeneration + 1L : this.projectsMarkedForDeletionGeneration);
        }
    }
}

