/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import java.util.Locale;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.shrink.ResizeNumberOfShardsCalculator;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportResizeAction
extends TransportMasterNodeAction<ResizeRequest, CreateIndexResponse> {
    private final MetadataCreateIndexService createIndexService;
    private final ProjectResolver projectResolver;
    private final Client client;

    @Inject
    public TransportResizeAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, ProjectResolver projectResolver, Client client) {
        this("indices:admin/resize", transportService, clusterService, threadPool, createIndexService, actionFilters, projectResolver, client);
    }

    protected TransportResizeAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, ActionFilters actionFilters, ProjectResolver projectResolver, Client client) {
        super(actionName, transportService, clusterService, threadPool, actionFilters, ResizeRequest::new, CreateIndexResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.createIndexService = createIndexService;
        this.projectResolver = projectResolver;
        this.client = client;
    }

    @Override
    protected ClusterBlockException checkBlock(ResizeRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE, request.getTargetIndexRequest().index());
    }

    @Override
    protected void masterOperation(Task task, ResizeRequest resizeRequest, ClusterState state, ActionListener<CreateIndexResponse> listener) {
        String sourceIndex = IndexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getSourceIndex());
        String targetIndex = IndexNameExpressionResolver.resolveDateMathExpression(resizeRequest.getTargetIndexRequest().index());
        ProjectMetadata projectMetadata = this.projectResolver.getProjectMetadata(state);
        IndexMetadata sourceMetadata = projectMetadata.index(sourceIndex);
        if (sourceMetadata == null) {
            listener.onFailure(new IndexNotFoundException(sourceIndex));
            return;
        }
        if (resizeRequest.getResizeType() == ResizeType.SPLIT) {
            IndexRouting.fromIndexMetadata(sourceMetadata).checkIndexSplitAllowed();
        }
        this.createTargetNumberOfShardsDecider(sourceIndex, resizeRequest, task, listener.delegateFailure((delegatedListener, targetNumberOfShardsDecider) -> {
            CreateIndexClusterStateUpdateRequest updateRequest;
            try {
                updateRequest = TransportResizeAction.prepareCreateIndexRequest(resizeRequest, projectMetadata.id(), sourceMetadata, targetIndex, targetNumberOfShardsDecider);
            }
            catch (Exception e) {
                delegatedListener.onFailure(e);
                return;
            }
            this.createIndexService.createIndex(resizeRequest.masterNodeTimeout(), resizeRequest.ackTimeout(), resizeRequest.ackTimeout(), updateRequest, delegatedListener.map(response -> new CreateIndexResponse(response.isAcknowledged(), response.isShardsAcknowledged(), updateRequest.index())));
        }));
    }

    void createTargetNumberOfShardsDecider(String sourceIndex, ResizeRequest resizeRequest, Task task, ActionListener<ResizeNumberOfShardsCalculator> listener) {
        if (resizeRequest.getResizeType() == ResizeType.SHRINK) {
            IndicesStatsRequestBuilder statsRequestBuilder = this.client.admin().indices().prepareStats(sourceIndex).clear().setDocs(true).setStore(true);
            IndicesStatsRequest statsRequest = (IndicesStatsRequest)statsRequestBuilder.request();
            statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
            this.client.execute(IndicesStatsAction.INSTANCE, statsRequest, listener.safeMap(indicesStatsResponse -> new ResizeNumberOfShardsCalculator.ShrinkShardsCalculator(indicesStatsResponse.getPrimaries().store, i -> {
                IndexShardStats shard = indicesStatsResponse.getIndex(sourceIndex).getIndexShards().get(i);
                return shard == null ? null : shard.getPrimary().getDocs();
            })));
        } else if (resizeRequest.getResizeType() == ResizeType.SPLIT) {
            listener.onResponse(new ResizeNumberOfShardsCalculator.SplitShardsCalculator());
        } else {
            assert (resizeRequest.getResizeType() == ResizeType.CLONE);
            listener.onResponse(new ResizeNumberOfShardsCalculator.CloneShardsCalculator());
        }
    }

    static CreateIndexClusterStateUpdateRequest prepareCreateIndexRequest(ResizeRequest resizeRequest, ProjectId projectId, IndexMetadata sourceMetadata, String targetIndexName, ResizeNumberOfShardsCalculator resizeNumberOfShardsCalculator) {
        CreateIndexRequest targetIndex = resizeRequest.getTargetIndexRequest();
        Settings.Builder targetIndexSettingsBuilder = Settings.builder().put(targetIndex.settings()).normalizePrefix("index.");
        targetIndexSettingsBuilder.remove("index.history.uuid");
        Settings targetIndexSettings = targetIndexSettingsBuilder.build();
        Integer requestedNumberOfShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings) ? IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings) : null;
        ByteSizeValue maxPrimaryShardSize = resizeRequest.getMaxPrimaryShardSize();
        int targetNumberOfShards = resizeNumberOfShardsCalculator.calculate(requestedNumberOfShards, maxPrimaryShardSize, sourceMetadata);
        resizeNumberOfShardsCalculator.validate(targetNumberOfShards, sourceMetadata);
        if (IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.exists(targetIndexSettings)) {
            throw new IllegalArgumentException("cannot provide a routing partition size value when resizing an index");
        }
        if (IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(targetIndexSettings)) {
            boolean splitFromSingleShards;
            boolean bl = splitFromSingleShards = resizeRequest.getResizeType() == ResizeType.SPLIT && sourceMetadata.getNumberOfShards() == 1;
            if (!splitFromSingleShards) {
                throw new IllegalArgumentException("cannot provide index.number_of_routing_shards on resize");
            }
        }
        if (IndexSettings.INDEX_SOFT_DELETES_SETTING.get(sourceMetadata.getSettings()).booleanValue() && IndexSettings.INDEX_SOFT_DELETES_SETTING.exists(targetIndexSettings) && !IndexSettings.INDEX_SOFT_DELETES_SETTING.get(targetIndexSettings).booleanValue()) {
            throw new IllegalArgumentException("Can't disable [index.soft_deletes.enabled] setting on resize");
        }
        String cause = resizeRequest.getResizeType().name().toLowerCase(Locale.ROOT) + "_index";
        targetIndex.cause(cause);
        Settings.Builder settingsBuilder = Settings.builder().put(targetIndexSettings);
        settingsBuilder.put("index.number_of_shards", targetNumberOfShards);
        targetIndex.settings(settingsBuilder);
        return new CreateIndexClusterStateUpdateRequest(cause, projectId, targetIndex.index(), targetIndexName).settings(targetIndex.settings()).aliases(targetIndex.aliases()).waitForActiveShards(targetIndex.waitForActiveShards()).recoverFrom(sourceMetadata.getIndex()).resizeType(resizeRequest.getResizeType()).copySettings(resizeRequest.getCopySettings() == null ? false : resizeRequest.getCopySettings());
    }
}

