/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.EnterpriseSearchBaseRestHandler;
import org.elasticsearch.xpack.application.search.action.RenderSearchApplicationQueryAction;
import org.elasticsearch.xpack.application.search.action.SearchApplicationSearchRequest;
import org.elasticsearch.xpack.application.utils.LicenseUtils;

public class RestRenderSearchApplicationQueryAction
extends EnterpriseSearchBaseRestHandler {
    public static final String ENDPOINT_PATH = "/_application/search_application/{name}/_render_query";

    public RestRenderSearchApplicationQueryAction(XPackLicenseState licenseState) {
        super(licenseState, LicenseUtils.Product.SEARCH_APPLICATION);
    }

    public String getName() {
        return "search_application_render_query_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, ENDPOINT_PATH));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        SearchApplicationSearchRequest request;
        String searchAppName = restRequest.param("name");
        if (restRequest.hasContent()) {
            try (XContentParser parser = restRequest.contentParser();){
                request = SearchApplicationSearchRequest.fromXContent(searchAppName, parser);
            }
        } else {
            request = new SearchApplicationSearchRequest(searchAppName);
        }
        SearchApplicationSearchRequest finalRequest = request;
        return channel -> client.execute(RenderSearchApplicationQueryAction.INSTANCE, (ActionRequest)finalRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

