/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.rules.QueryRule;

public class GetQueryRuleAction {
    public static final String NAME = "cluster:admin/xpack/query_rules/rule/get";
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/query_rules/rule/get");

    private GetQueryRuleAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final QueryRule queryRule;

        public Response(StreamInput in) throws IOException {
            this.queryRule = new QueryRule(in);
        }

        public Response(QueryRule queryRule) {
            this.queryRule = queryRule;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.queryRule.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.queryRule.toXContent(builder, params);
        }

        public QueryRule queryRule() {
            return this.queryRule;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.queryRule, response.queryRule);
        }

        public int hashCode() {
            return Objects.hash(this.queryRule);
        }

        public static Response fromXContent(XContentParser parser) throws IOException {
            return new Response(QueryRule.fromXContent(parser));
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements ToXContentObject {
        private final String rulesetId;
        private final String ruleId;
        private static final ParseField RULESET_ID_FIELD = new ParseField("ruleset_id", new String[0]);
        private static final ParseField RULE_ID_FIELD = new ParseField("rule_id", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("get_query_rule_request", false, p -> new Request((String)p[0], (String)p[1]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.rulesetId = in.readString();
            this.ruleId = in.readString();
        }

        public Request(String rulesetId, String ruleId) {
            this.rulesetId = rulesetId;
            this.ruleId = ruleId;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.rulesetId)) {
                validationException = ValidateActions.addValidationError((String)"ruleset_id missing", validationException);
            }
            if (Strings.isNullOrEmpty((String)this.ruleId)) {
                validationException = ValidateActions.addValidationError((String)"rule_id missing", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.rulesetId);
            out.writeString(this.ruleId);
        }

        public String rulesetId() {
            return this.rulesetId;
        }

        public String ruleId() {
            return this.ruleId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.rulesetId, request.rulesetId) && Objects.equals(this.ruleId, request.ruleId);
        }

        public int hashCode() {
            return Objects.hash(this.rulesetId, this.ruleId);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(RULESET_ID_FIELD.getPreferredName(), this.rulesetId);
            builder.field(RULE_ID_FIELD.getPreferredName(), this.ruleId);
            builder.endObject();
            return builder;
        }

        public static Request parse(XContentParser parser, String name) {
            return (Request)((Object)PARSER.apply(parser, (Object)name));
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), RULESET_ID_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), RULE_ID_FIELD);
        }
    }
}

