/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.application.rules.QueryRule;
import org.elasticsearch.xpack.application.rules.QueryRuleCriteriaType;

public class QueryRulesetListItem
implements Writeable,
ToXContentObject {
    public static final TransportVersion EXPANDED_RULESET_COUNT_TRANSPORT_VERSION = TransportVersions.V_8_10_X;
    public static final ParseField RULESET_ID_FIELD = new ParseField("ruleset_id", new String[0]);
    public static final ParseField RULE_TOTAL_COUNT_FIELD = new ParseField("rule_total_count", new String[0]);
    public static final ParseField RULE_CRITERIA_TYPE_COUNTS_FIELD = new ParseField("rule_criteria_types_counts", new String[0]);
    public static final ParseField RULE_TYPE_COUNTS_FIELD = new ParseField("rule_type_counts", new String[0]);
    private final String rulesetId;
    private final int ruleTotalCount;
    private final Map<QueryRuleCriteriaType, Integer> criteriaTypeToCountMap;
    private final Map<QueryRule.QueryRuleType, Integer> ruleTypeToCountMap;

    public QueryRulesetListItem(String rulesetId, int ruleTotalCount, Map<QueryRuleCriteriaType, Integer> criteriaTypeToCountMap, Map<QueryRule.QueryRuleType, Integer> ruleTypeToCountMap) {
        Objects.requireNonNull(rulesetId, "rulesetId cannot be null on a QueryRuleListItem");
        this.rulesetId = rulesetId;
        this.ruleTotalCount = ruleTotalCount;
        this.criteriaTypeToCountMap = criteriaTypeToCountMap;
        this.ruleTypeToCountMap = ruleTypeToCountMap;
    }

    public QueryRulesetListItem(StreamInput in) throws IOException {
        this.rulesetId = in.readString();
        this.ruleTotalCount = in.readInt();
        this.criteriaTypeToCountMap = in.getTransportVersion().onOrAfter((VersionId)EXPANDED_RULESET_COUNT_TRANSPORT_VERSION) ? in.readMap(m -> (QueryRuleCriteriaType)in.readEnum(QueryRuleCriteriaType.class), StreamInput::readInt) : Map.of();
        TransportVersion streamTransportVersion = in.getTransportVersion();
        this.ruleTypeToCountMap = streamTransportVersion.onOrAfter((VersionId)TransportVersions.V_8_16_1) ? in.readMap(m -> (QueryRule.QueryRuleType)in.readEnum(QueryRule.QueryRuleType.class), StreamInput::readInt) : Map.of();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(RULESET_ID_FIELD.getPreferredName(), this.rulesetId);
        builder.field(RULE_TOTAL_COUNT_FIELD.getPreferredName(), this.ruleTotalCount);
        builder.startObject(RULE_CRITERIA_TYPE_COUNTS_FIELD.getPreferredName());
        for (QueryRuleCriteriaType criteriaType : this.criteriaTypeToCountMap.keySet()) {
            builder.field(criteriaType.name().toLowerCase(Locale.ROOT), this.criteriaTypeToCountMap.get((Object)criteriaType));
        }
        builder.endObject();
        builder.startObject(RULE_TYPE_COUNTS_FIELD.getPreferredName());
        for (QueryRule.QueryRuleType ruleType : this.ruleTypeToCountMap.keySet()) {
            builder.field(ruleType.name().toLowerCase(Locale.ROOT), this.ruleTypeToCountMap.get((Object)ruleType));
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        TransportVersion streamTransportVersion;
        out.writeString(this.rulesetId);
        out.writeInt(this.ruleTotalCount);
        if (out.getTransportVersion().onOrAfter((VersionId)EXPANDED_RULESET_COUNT_TRANSPORT_VERSION)) {
            out.writeMap(this.criteriaTypeToCountMap, StreamOutput::writeEnum, StreamOutput::writeInt);
        }
        if ((streamTransportVersion = out.getTransportVersion()).onOrAfter((VersionId)TransportVersions.V_8_16_1)) {
            out.writeMap(this.ruleTypeToCountMap, StreamOutput::writeEnum, StreamOutput::writeInt);
        }
    }

    public String rulesetId() {
        return this.rulesetId;
    }

    public int ruleTotalCount() {
        return this.ruleTotalCount;
    }

    public Map<QueryRuleCriteriaType, Integer> criteriaTypeToCountMap() {
        return this.criteriaTypeToCountMap;
    }

    public Map<QueryRule.QueryRuleType, Integer> ruleTypeToCountMap() {
        return this.ruleTypeToCountMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryRulesetListItem that = (QueryRulesetListItem)o;
        return this.ruleTotalCount == that.ruleTotalCount && Objects.equals(this.rulesetId, that.rulesetId) && Objects.equals(this.criteriaTypeToCountMap, that.criteriaTypeToCountMap) && Objects.equals(this.ruleTypeToCountMap, that.ruleTypeToCountMap);
    }

    public int hashCode() {
        return Objects.hash(this.rulesetId, this.ruleTotalCount, this.criteriaTypeToCountMap, this.ruleTypeToCountMap);
    }
}

