/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic;

import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.ArithmeticOperation;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.DefaultBinaryArithmeticOperation;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;

public class Div
extends ArithmeticOperation
implements BinaryComparisonInversible {
    private DataType dataType;

    public Div(Source source, Expression left, Expression right) {
        this(source, left, right, (DataType)null);
    }

    public Div(Source source, Expression left, Expression right, DataType dataType) {
        super(source, left, right, DefaultBinaryArithmeticOperation.DIV);
        this.dataType = dataType;
    }

    @Override
    protected NodeInfo<Div> info() {
        return NodeInfo.create(this, Div::new, this.left(), this.right(), this.dataType);
    }

    @Override
    protected Div replaceChildren(Expression newLeft, Expression newRight) {
        return new Div(this.source(), newLeft, newRight, this.dataType);
    }

    @Override
    public DataType dataType() {
        if (this.dataType == null) {
            this.dataType = DataTypeConverter.commonType(this.left().dataType(), this.right().dataType());
        }
        return this.dataType;
    }

    @Override
    public BinaryComparisonInversible.ArithmeticOperationFactory binaryComparisonInverse() {
        return Mul::new;
    }
}

