/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.proto.content;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.xpack.sql.proto.content.ContentLocation;
import org.elasticsearch.xpack.sql.proto.content.ParseException;
import org.elasticsearch.xpack.sql.proto.core.Booleans;

public class ParserUtils {
    private ParserUtils() {
    }

    public static boolean booleanValue(JsonParser p) throws IOException {
        JsonToken token = p.currentToken();
        if (token == JsonToken.VALUE_STRING) {
            return Booleans.parseBoolean(p.getTextCharacters(), p.getTextOffset(), p.getTextLength(), false);
        }
        return p.getBooleanValue();
    }

    public static Integer intValue(JsonParser p) throws IOException {
        JsonToken token = p.currentToken();
        if (token == JsonToken.VALUE_STRING) {
            String text = ParserUtils.text(p);
            double doubleValue = Double.parseDouble(text);
            if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                throw new IllegalArgumentException("Value [" + text + "] is out of range for an integer");
            }
            return (int)doubleValue;
        }
        return p.getIntValue();
    }

    public static String text(JsonParser p) throws IOException {
        JsonToken current = p.currentToken();
        if (current.isScalarValue()) {
            return p.getText();
        }
        throw new IllegalStateException("Can't get text on a " + current + " at " + ParserUtils.location(p));
    }

    public static Map<String, Object> map(JsonParser p) throws IOException {
        return ParserUtils.readMapSafe(p, HashMap::new);
    }

    public static Map<String, Object> mapOrdered(JsonParser p) throws IOException {
        return ParserUtils.readMapSafe(p, LinkedHashMap::new);
    }

    public static Map<String, Object> readMapSafe(JsonParser p, Supplier<Map<String, Object>> mapFactory) throws IOException {
        Map<String, Object> map = mapFactory.get();
        return ParserUtils.findNonEmptyMapStart(p) ? ParserUtils.readMapEntries(p, mapFactory, map) : map;
    }

    private static boolean findNonEmptyMapStart(JsonParser parser) throws IOException {
        JsonToken token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == JsonToken.START_OBJECT) {
            token = parser.nextToken();
        }
        return token == JsonToken.FIELD_NAME;
    }

    private static Map<String, Object> readMapEntries(JsonParser parser, Supplier<Map<String, Object>> mapFactory, Map<String, Object> map) throws IOException {
        assert (parser.currentToken() == JsonToken.FIELD_NAME) : "Expected field name but saw [" + parser.currentToken() + "]";
        do {
            String fieldName = parser.currentName();
            Object value = ParserUtils.readValueUnsafe(parser.nextToken(), parser, mapFactory);
            map.put(fieldName, value);
        } while (parser.nextToken() == JsonToken.FIELD_NAME);
        return map;
    }

    public static List<Object> list(JsonParser parser) throws IOException {
        ParserUtils.skipToListStart(parser);
        return ParserUtils.readListUnsafe(parser, HashMap::new);
    }

    public static List<Object> listOrderedMap(JsonParser parser) throws IOException {
        ParserUtils.skipToListStart(parser);
        return ParserUtils.readListUnsafe(parser, LinkedHashMap::new);
    }

    private static void skipToListStart(JsonParser parser) throws IOException {
        JsonToken token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == JsonToken.FIELD_NAME) {
            token = parser.nextToken();
        }
        if (token != JsonToken.START_ARRAY) {
            throw new ParseException(ParserUtils.location(parser), "Failed to parse list:  expecting " + JsonToken.START_ARRAY + " but got " + token);
        }
    }

    private static Object readValueUnsafe(JsonToken currentToken, JsonParser parser, Supplier<Map<String, Object>> mapFactory) throws IOException {
        if (currentToken != parser.currentToken()) {
            throw new ParseException("Supplied current token [" + currentToken + "] is different from actual parser current token [" + parser.currentToken() + "]");
        }
        switch (currentToken) {
            case VALUE_STRING: {
                return ParserUtils.text(parser);
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return parser.getNumberValue();
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return parser.getBooleanValue();
            }
            case START_OBJECT: {
                Map<String, Object> map = mapFactory.get();
                return parser.nextToken() != JsonToken.FIELD_NAME ? map : ParserUtils.readMapEntries(parser, mapFactory, map);
            }
            case START_ARRAY: {
                return ParserUtils.readListUnsafe(parser, mapFactory);
            }
            case VALUE_EMBEDDED_OBJECT: {
                return parser.getBinaryValue();
            }
        }
        return null;
    }

    private static List<Object> readListUnsafe(JsonParser parser, Supplier<Map<String, Object>> mapFactory) throws IOException {
        if (parser.currentToken() != JsonToken.START_ARRAY) {
            throw new ParseException(ParserUtils.location(parser), "Expected START_ARRAY but got [" + parser.currentToken() + "]");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        JsonToken token = parser.nextToken();
        while (token != null && token != JsonToken.END_ARRAY) {
            list.add(ParserUtils.readValueUnsafe(token, parser, mapFactory));
            token = parser.nextToken();
        }
        return list;
    }

    public static ContentLocation location(JsonParser p) {
        return ParserUtils.location(p.getTokenLocation());
    }

    public static ContentLocation location(JsonLocation tokenLocation) {
        return tokenLocation != null ? new ContentLocation(tokenLocation.getLineNr(), tokenLocation.getColumnNr()) : ContentLocation.UNKNOWN;
    }
}

