/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.action;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.autoscaling.AutoscalingLicenseChecker;
import org.elasticsearch.xpack.autoscaling.AutoscalingMetadata;
import org.elasticsearch.xpack.autoscaling.action.PolicyValidator;
import org.elasticsearch.xpack.autoscaling.action.PutAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCalculateCapacityService;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicy;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicyMetadata;

public class TransportPutAutoscalingPolicyAction
extends AcknowledgedTransportMasterNodeAction<PutAutoscalingPolicyAction.Request> {
    private static final Logger LOGGER = LogManager.getLogger(TransportPutAutoscalingPolicyAction.class);
    private final PolicyValidator policyValidator;
    private final AutoscalingLicenseChecker autoscalingLicenseChecker;

    @Inject
    public TransportPutAutoscalingPolicyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, AutoscalingCalculateCapacityService.Holder policyValidatorHolder, AutoscalingLicenseChecker autoscalingLicenseChecker) {
        this(transportService, clusterService, threadPool, actionFilters, policyValidatorHolder.get(), autoscalingLicenseChecker);
    }

    TransportPutAutoscalingPolicyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PolicyValidator policyValidator, AutoscalingLicenseChecker autoscalingLicenseChecker) {
        super("cluster:admin/autoscaling/put_autoscaling_policy", transportService, clusterService, threadPool, actionFilters, PutAutoscalingPolicyAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.policyValidator = policyValidator;
        this.autoscalingLicenseChecker = Objects.requireNonNull(autoscalingLicenseChecker);
    }

    protected void masterOperation(Task task, final PutAutoscalingPolicyAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (!this.autoscalingLicenseChecker.isAutoscalingAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"autoscaling"));
            return;
        }
        this.submitUnbatchedTask("put-autoscaling-policy", (ClusterStateUpdateTask)new AckedClusterStateUpdateTask(request, listener){

            public ClusterState execute(ClusterState currentState) {
                return TransportPutAutoscalingPolicyAction.putAutoscalingPolicy(currentState, request, TransportPutAutoscalingPolicyAction.this.policyValidator, LOGGER);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(PutAutoscalingPolicyAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    static ClusterState putAutoscalingPolicy(ClusterState currentState, PutAutoscalingPolicyAction.Request request, PolicyValidator policyValidator) {
        return TransportPutAutoscalingPolicyAction.putAutoscalingPolicy(currentState, request, policyValidator, LOGGER);
    }

    static ClusterState putAutoscalingPolicy(ClusterState currentState, PutAutoscalingPolicyAction.Request request, PolicyValidator policyValidator, Logger logger) {
        AutoscalingPolicy updatedPolicy;
        ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
        AutoscalingMetadata currentMetadata = currentState.metadata().custom("autoscaling") != null ? (AutoscalingMetadata)currentState.metadata().custom("autoscaling") : AutoscalingMetadata.EMPTY;
        AutoscalingPolicyMetadata existingPolicyMetadata = (AutoscalingPolicyMetadata)currentMetadata.policies().get(request.name());
        if (existingPolicyMetadata == null) {
            if (request.roles() == null) {
                throw new IllegalArgumentException("new policy " + request.name() + " with no roles defined, must provide empty list for no roles");
            }
            updatedPolicy = new AutoscalingPolicy(request.name(), request.roles(), request.deciders() != null ? request.deciders() : Collections.emptySortedMap());
        } else {
            AutoscalingPolicy existing = existingPolicyMetadata.policy();
            updatedPolicy = new AutoscalingPolicy(request.name(), request.roles() != null ? request.roles() : existing.roles(), request.deciders() != null ? request.deciders() : existing.deciders());
        }
        policyValidator.validate(updatedPolicy);
        TreeMap<String, AutoscalingPolicyMetadata> newPolicies = new TreeMap<String, AutoscalingPolicyMetadata>(currentMetadata.policies());
        AutoscalingPolicyMetadata newPolicyMetadata = new AutoscalingPolicyMetadata(updatedPolicy);
        AutoscalingPolicyMetadata oldPolicyMetadata = newPolicies.put(request.name(), newPolicyMetadata);
        if (oldPolicyMetadata == null) {
            logger.info("adding autoscaling policy [{}]", (Object)request.name());
        } else {
            if (oldPolicyMetadata.equals(newPolicyMetadata)) {
                logger.info("skipping updating autoscaling policy [{}] due to no change in policy", (Object)request.name());
                return currentState;
            }
            logger.info("updating autoscaling policy [{}]", (Object)request.name());
        }
        AutoscalingMetadata newMetadata = new AutoscalingMetadata(newPolicies);
        builder.metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("autoscaling", (Metadata.ClusterCustom)newMetadata).build());
        return builder.build();
    }

    public Optional<String> reservedStateHandlerName() {
        return Optional.of("autoscaling");
    }

    public Set<String> modifiedKeys(PutAutoscalingPolicyAction.Request request) {
        return Set.of(request.name());
    }
}

