/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.models;

import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ParseNodeFactoryRegistry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public interface DecryptableContent {
    public void setData(@Nullable String var1);

    @Nullable
    public String getData();

    public void setDataKey(@Nullable String var1);

    @Nullable
    public String getDataKey();

    public void setDataSignature(@Nullable String var1);

    @Nullable
    public String getDataSignature();

    public void setEncryptionCertificateId(@Nullable String var1);

    @Nullable
    public String getEncryptionCertificateId();

    public void setEncryptionCertificateThumbprint(@Nullable String var1);

    @Nullable
    public String getEncryptionCertificateThumbprint();

    @Nonnull
    public static <T extends Parsable> T decrypt(@Nonnull DecryptableContent decryptableContent, @Nonnull CertificateKeyProvider certificateKeyProvider, @Nonnull ParsableFactory<T> factory) throws Exception {
        Objects.requireNonNull(certificateKeyProvider);
        String decryptedContent = DecryptableContent.decryptAsString(decryptableContent, certificateKeyProvider);
        ParseNode rootParseNode = ParseNodeFactoryRegistry.defaultInstance.getParseNode("application/json", (InputStream)new ByteArrayInputStream(decryptedContent.getBytes(StandardCharsets.UTF_8)));
        return (T)rootParseNode.getObjectValue(factory);
    }

    @Nonnull
    public static String decryptAsString(@Nonnull DecryptableContent content, @Nonnull CertificateKeyProvider certificateKeyProvider) throws Exception {
        Objects.requireNonNull(content);
        Objects.requireNonNull(certificateKeyProvider);
        Key privateKey = certificateKeyProvider.getCertificateKey(content.getEncryptionCertificateId(), content.getEncryptionCertificateThumbprint());
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING");
        cipher.init(2, privateKey);
        byte[] decryptedSymmetricKey = cipher.doFinal(Base64.getDecoder().decode(content.getDataKey()));
        Mac sha256Mac = Mac.getInstance("HmacSHA256");
        sha256Mac.init(new SecretKeySpec(decryptedSymmetricKey, "HmacSHA256"));
        byte[] hashedData = sha256Mac.doFinal(Base64.getDecoder().decode(content.getData()));
        String expectedSignature = Base64.getEncoder().encodeToString(hashedData);
        if (!expectedSignature.equals(content.getDataSignature())) {
            throw new Exception("Signature does not match");
        }
        return new String(DecryptableContent.aesDecrypt(Base64.getDecoder().decode(content.getData()), decryptedSymmetricKey), StandardCharsets.UTF_8);
    }

    @Nonnull
    public static byte[] aesDecrypt(@Nonnull byte[] data, @Nonnull byte[] key) throws Exception {
        Objects.requireNonNull(data);
        Objects.requireNonNull(key);
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(Arrays.copyOf(key, 16));
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)new SecretKeySpec(key, "AES"), ivSpec);
            return cipher.doFinal(data);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected error occurred while trying to decrypt the data", ex);
        }
    }

    @FunctionalInterface
    public static interface CertificateKeyProvider {
        @Nonnull
        public Key getCertificateKey(@Nullable String var1, @Nullable String var2);
    }
}

