/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr.security;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.UUID;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.token.Token;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.mr.security.EsTokenIdentifier;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.security.EsToken;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.ClusterName;

public class TokenUtil {
    private static Log LOG = LogFactory.getLog(TokenUtil.class);
    public static final String KEY_NAME_PREFIX = "ESHADOOP_";

    private static String newKeyName() {
        return KEY_NAME_PREFIX + UUID.randomUUID().toString();
    }

    private static EsToken obtainEsToken(final RestClient client, User user) {
        KerberosPrincipal principal = user.getKerberosPrincipal();
        if (user.isProxyUser()) {
            principal = user.getRealUserProvider().getUser().getKerberosPrincipal();
        }
        Assert.isTrue(principal != null, "Kerberos credentials are missing on current user");
        return user.doAs(new PrivilegedExceptionAction<EsToken>(){

            @Override
            public EsToken run() {
                return client.createNewApiToken(TokenUtil.newKeyName());
            }
        });
    }

    public static Token<EsTokenIdentifier> obtainToken(RestClient client, User user) {
        EsToken esToken = TokenUtil.obtainEsToken(client, user);
        return EsTokenIdentifier.createTokenFrom(esToken);
    }

    public static void obtainAndCache(RestClient client, User user) throws IOException {
        EsToken token = TokenUtil.obtainEsToken(client, user);
        if (token == null) {
            throw new IOException("No token returned for user " + user.getKerberosPrincipal().getName());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Obtained token " + EsTokenIdentifier.KIND_NAME + " for user " + user.getKerberosPrincipal().getName()));
        }
        user.addEsToken(token);
    }

    public static void obtainTokenForJob(RestClient client, User user, Job job) {
        Token<EsTokenIdentifier> token = TokenUtil.obtainToken(client, user);
        if (token == null) {
            throw new EsHadoopException("No token returned for user " + user.getKerberosPrincipal().getName());
        }
        Text clusterName = token.getService();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Obtained token " + EsTokenIdentifier.KIND_NAME.toString() + " for user " + user.getKerberosPrincipal().getName() + " on cluster " + clusterName.toString()));
        }
        job.getCredentials().addToken(clusterName, token);
    }

    public static void obtainTokenForJob(RestClient client, User user, JobConf jobConf) {
        Token<EsTokenIdentifier> token = TokenUtil.obtainToken(client, user);
        if (token == null) {
            throw new EsHadoopException("No token returned for user " + user.getKerberosPrincipal().getName());
        }
        Text clusterName = token.getService();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Obtained token " + EsTokenIdentifier.KIND_NAME.toString() + " for user " + user.getKerberosPrincipal().getName() + " on cluster " + clusterName.toString()));
        }
        jobConf.getCredentials().addToken(clusterName, token);
    }

    public static void addTokenForJob(RestClient client, ClusterName clusterName, User user, Job job) {
        Token<EsTokenIdentifier> token = TokenUtil.getAuthToken(clusterName, user);
        if (token == null) {
            token = TokenUtil.obtainToken(client, user);
        }
        job.getCredentials().addToken(token.getService(), token);
    }

    public static void addTokenForJobConf(RestClient client, ClusterName clusterName, User user, JobConf job) {
        Token<EsTokenIdentifier> token = TokenUtil.getAuthToken(clusterName, user);
        if (token == null) {
            token = TokenUtil.obtainToken(client, user);
        }
        job.getCredentials().addToken(token.getService(), token);
    }

    private static Token<EsTokenIdentifier> getAuthToken(ClusterName clusterName, User user) {
        EsToken esToken = TokenUtil.getEsAuthToken(clusterName, user);
        if (esToken == null) {
            return null;
        }
        return EsTokenIdentifier.createTokenFrom(esToken);
    }

    private static EsToken getEsAuthToken(ClusterName clusterName, User user) {
        return user.getEsToken(clusterName.getName());
    }
}

