/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockRequest;
import org.elasticsearch.action.admin.indices.readonly.TransportAddIndexBlockAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class ReadOnlyStep
extends AsyncActionStep {
    public static final String NAME = "readonly";
    private final boolean markVerified;

    public ReadOnlyStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, boolean markVerified) {
        super(key, nextStepKey, client);
        this.markVerified = markVerified;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ProjectState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        this.getClient(currentState.projectId()).admin().indices().execute(TransportAddIndexBlockAction.TYPE, ((AddIndexBlockRequest)new AddIndexBlockRequest(IndexMetadata.APIBlock.WRITE, indexMetadata.getIndex().getName()).masterNodeTimeout(TimeValue.MAX_VALUE)).markVerified(this.markVerified), listener.delegateFailureAndWrap((l, response) -> {
            if (!response.isAcknowledged()) {
                throw new ElasticsearchException("read only add block index request failed to be acknowledged", new Object[0]);
            }
            l.onResponse(null);
        }));
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

