/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;

public class DiversifyingParentBlockQuery
extends Query {
    private final BitSetProducer parentFilter;
    private final Query innerQuery;

    public DiversifyingParentBlockQuery(BitSetProducer parentFilter, Query innerQuery) {
        this.parentFilter = Objects.requireNonNull(parentFilter);
        this.innerQuery = Objects.requireNonNull(innerQuery);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewritten = this.innerQuery.rewrite(indexSearcher);
        if (rewritten != this.innerQuery) {
            return new DiversifyingParentBlockQuery(this.parentFilter, rewritten);
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        Weight innerWeight = this.innerQuery.createWeight(searcher, scoreMode, boost);
        return new DiversifyingParentBlockWeight(this, innerWeight, this.parentFilter);
    }

    @Override
    public String toString(String field) {
        return "DiversifyingBlockQuery(inner=" + this.innerQuery.toString(field) + ")";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        this.innerQuery.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiversifyingParentBlockQuery that = (DiversifyingParentBlockQuery)o;
        return Objects.equals(this.innerQuery, that.innerQuery) && this.parentFilter == that.parentFilter;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.innerQuery, this.parentFilter);
    }

    private static class DiversifyingParentBlockWeight
    extends Weight {
        private final Weight innerWeight;
        private final BitSetProducer parentFilter;

        DiversifyingParentBlockWeight(Query query, Weight innerWeight, BitSetProducer parentFilter) {
            super(query);
            this.innerWeight = innerWeight;
            this.parentFilter = parentFilter;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            return this.innerWeight.explain(context, doc);
        }

        @Override
        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            final ScorerSupplier innerSupplier = this.innerWeight.scorerSupplier(context);
            final BitSet parentBits = this.parentFilter.getBitSet(context);
            if (parentBits == null || innerSupplier == null) {
                return null;
            }
            return new ScorerSupplier(this){

                @Override
                public Scorer get(long leadCost) throws IOException {
                    final Scorer innerScorer = innerSupplier.get(leadCost);
                    final DocIdSetIterator innerIterator = innerScorer.iterator();
                    return new Scorer(){
                        int currentDoc = -1;
                        float currentScore = Float.NaN;

                        @Override
                        public int docID() {
                            return this.currentDoc;
                        }

                        @Override
                        public DocIdSetIterator iterator() {
                            return new DocIdSetIterator(){
                                boolean exhausted = false;

                                @Override
                                public int docID() {
                                    return currentDoc;
                                }

                                @Override
                                public int nextDoc() throws IOException {
                                    return this.advance(currentDoc + 1);
                                }

                                @Override
                                public int advance(int target) throws IOException {
                                    int innerDoc;
                                    if (this.exhausted) {
                                        currentDoc = Integer.MAX_VALUE;
                                        return Integer.MAX_VALUE;
                                    }
                                    if ((currentDoc == -1 || innerIterator.docID() < target) && innerIterator.advance(target) == Integer.MAX_VALUE) {
                                        this.exhausted = true;
                                        currentDoc = Integer.MAX_VALUE;
                                        return Integer.MAX_VALUE;
                                    }
                                    int bestChild = innerIterator.docID();
                                    float bestScore = innerScorer.score();
                                    int parent = parentBits.nextSetBit(bestChild);
                                    while ((innerDoc = innerIterator.nextDoc()) < parent) {
                                        float score = innerScorer.score();
                                        if (!(score > bestScore)) continue;
                                        bestChild = innerIterator.docID();
                                        bestScore = score;
                                    }
                                    if (innerDoc == Integer.MAX_VALUE) {
                                        this.exhausted = true;
                                    }
                                    currentScore = bestScore;
                                    currentDoc = bestChild;
                                    return currentDoc;
                                }

                                @Override
                                public long cost() {
                                    return innerIterator.cost();
                                }
                            };
                        }

                        @Override
                        public float score() throws IOException {
                            return this.currentScore;
                        }

                        @Override
                        public float getMaxScore(int upTo) throws IOException {
                            return innerScorer.getMaxScore(upTo);
                        }
                    };
                }

                @Override
                public long cost() {
                    return innerSupplier.cost();
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }
    }
}

