/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestChunkedToXContentListener;
import org.elasticsearch.xcontent.ToXContent;

@ServerlessScope(value=Scope.INTERNAL)
public class RestClusterStateAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS = Sets.addToCopy(Settings.FORMAT_PARAMS, "metric");
    private final SettingsFilter settingsFilter;

    public RestClusterStateAction(SettingsFilter settingsFilter) {
        this.settingsFilter = settingsFilter;
    }

    @Override
    public String getName() {
        return "cluster_state_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_cluster/state"), new RestHandler.Route(RestRequest.Method.GET, "/_cluster/state/{metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_cluster/state/{metric}/{indices}"));
    }

    @Override
    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Map<String, String> params;
        boolean isAllIndicesOnly;
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest(RestUtils.getMasterNodeTimeout(request));
        clusterStateRequest.indicesOptions(IndicesOptions.fromRequest(request, clusterStateRequest.indicesOptions()));
        RestUtils.consumeDeprecatedLocalParameter(request);
        if (request.hasParam("wait_for_metadata_version")) {
            clusterStateRequest.waitForMetadataVersion(request.paramAsLong("wait_for_metadata_version", 0L));
        }
        clusterStateRequest.waitForTimeout(request.paramAsTime("wait_for_timeout", ClusterStateRequest.DEFAULT_WAIT_FOR_NODE_TIMEOUT));
        String[] indices = Strings.splitStringByCommaToArray(request.param("indices", "_all"));
        boolean bl = isAllIndicesOnly = indices.length == 1 && "_all".equals(indices[0]);
        if (!isAllIndicesOnly) {
            clusterStateRequest.indices(indices);
        }
        if (request.hasParam("metric")) {
            EnumSet<ClusterState.Metric> metrics = ClusterState.Metric.parseString(request.param("metric"), true);
            clusterStateRequest.nodes(metrics.contains((Object)ClusterState.Metric.NODES) || metrics.contains((Object)ClusterState.Metric.MASTER_NODE));
            clusterStateRequest.routingTable(metrics.contains((Object)ClusterState.Metric.ROUTING_TABLE) || metrics.contains((Object)ClusterState.Metric.ROUTING_NODES));
            clusterStateRequest.metadata(metrics.contains((Object)ClusterState.Metric.METADATA));
            clusterStateRequest.blocks(metrics.contains((Object)ClusterState.Metric.BLOCKS));
            clusterStateRequest.customs(metrics.contains((Object)ClusterState.Metric.CUSTOMS));
        }
        this.settingsFilter.addFilterSettingParams(request);
        if (request.paramAsBoolean("multi_project", false)) {
            params = Map.of("context_mode", Metadata.CONTEXT_MODE_API, "multi-project", "true");
            clusterStateRequest.multiproject(true);
        } else {
            params = Map.of("context_mode", Metadata.CONTEXT_MODE_API);
        }
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute(ClusterStateAction.INSTANCE, clusterStateRequest, new RestChunkedToXContentListener<RestClusterStateResponse>((RestChannel)channel, new ToXContent.DelegatingMapParams(params, request)).map(response -> new RestClusterStateResponse(clusterStateRequest, (ClusterStateResponse)response)));
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    private record RestClusterStateResponse(ClusterStateRequest request, ClusterStateResponse response) implements ChunkedToXContent
    {
        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            ClusterState responseState = this.response.getState();
            return Iterators.concat(Iterators.single((builder, params) -> {
                builder.startObject();
                if (this.request.waitForMetadataVersion() != null) {
                    builder.field("wait_for_timed_out", this.response.isWaitForTimedOut());
                }
                builder.field("cluster_name", this.response.getClusterName().value());
                return builder;
            }), responseState == null ? Collections.emptyIterator() : responseState.toXContentChunked(outerParams), ChunkedToXContentHelper.endObject());
        }
    }

    static final class Fields {
        static final String WAIT_FOR_TIMED_OUT = "wait_for_timed_out";
        static final String CLUSTER_NAME = "cluster_name";

        Fields() {
        }
    }
}

