/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.ingest.GraphStructureException;
import org.elasticsearch.ingest.IngestCtxMap;
import org.elasticsearch.ingest.IngestDocMetadata;
import org.elasticsearch.ingest.IngestPipelineFieldAccessPattern;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.ValueSource;
import org.elasticsearch.script.CtxMap;
import org.elasticsearch.script.TemplateScript;

public final class IngestDocument {
    public static final String INGEST_KEY = "_ingest";
    public static final String SOURCE_KEY = "_source";
    private static final String INGEST_KEY_PREFIX = "_ingest.";
    private static final String SOURCE_PREFIX = "_source.";
    private static final String PIPELINE_CYCLE_ERROR_MESSAGE = "Cycle detected for pipeline: ";
    static final String TIMESTAMP = "timestamp";
    public static final int MAX_PIPELINES = Integer.parseInt(System.getProperty("es.ingest.max_pipelines", "100"));
    private static final Object NOT_FOUND = new Object();
    private final IngestCtxMap ctxMap;
    private final Map<String, Object> ingestMetadata;
    private final DelegatingMapView templateModel;
    private final Set<String> executedPipelines = new LinkedHashSet<String>();
    private final Deque<IngestPipelineFieldAccessPattern> accessPatternStack = new ArrayDeque<IngestPipelineFieldAccessPattern>();
    private final Set<String> indexHistory = new LinkedHashSet<String>();
    private boolean doNoSelfReferencesCheck = false;
    private boolean reroute = false;
    private boolean terminate = false;

    public IngestDocument(String index, String id, long version, String routing, VersionType versionType, Map<String, Object> source) {
        this.ctxMap = new IngestCtxMap(index, id, version, routing, versionType, ZonedDateTime.now(ZoneOffset.UTC), source);
        this.ingestMetadata = new HashMap<String, Object>();
        this.ingestMetadata.put(TIMESTAMP, ((IngestDocMetadata)this.ctxMap.getMetadata()).getNow());
        this.templateModel = this.initializeTemplateModel();
        this.indexHistory.add(index);
    }

    public IngestDocument(IngestDocument other) {
        this(new IngestCtxMap(IngestDocument.deepCopyMap(IngestDocument.ensureNoSelfReferences(other.ctxMap.getSource())), ((IngestDocMetadata)other.ctxMap.getMetadata()).clone()), IngestDocument.deepCopyMap(other.ingestMetadata));
        this.executedPipelines.addAll(other.executedPipelines);
        this.accessPatternStack.addAll(other.accessPatternStack);
    }

    private static Map<String, Object> ensureNoSelfReferences(Map<String, Object> source) {
        CollectionUtils.ensureNoSelfReferences(source, null);
        return source;
    }

    public IngestDocument(Map<String, Object> sourceAndMetadata, Map<String, Object> ingestMetadata) {
        Map<String, Object> metadata;
        HashMap<String, Object> source;
        if (sourceAndMetadata instanceof IngestCtxMap) {
            IngestCtxMap ingestCtxMap = (IngestCtxMap)sourceAndMetadata;
            source = new HashMap<String, Object>(ingestCtxMap.getSource());
            metadata = new HashMap<String, Object>(((IngestDocMetadata)ingestCtxMap.getMetadata()).getMap());
        } else {
            metadata = Maps.newHashMapWithExpectedSize(Metadata.METADATA_NAMES.size());
            source = new HashMap<String, Object>(sourceAndMetadata);
            for (String key : Metadata.METADATA_NAMES) {
                if (!sourceAndMetadata.containsKey(key)) continue;
                metadata.put(key, source.remove(key));
            }
        }
        this.ctxMap = new IngestCtxMap((Map<String, Object>)source, new IngestDocMetadata(metadata, IngestCtxMap.getTimestamp(ingestMetadata)));
        this.ingestMetadata = new HashMap<String, Object>(ingestMetadata);
        this.templateModel = this.initializeTemplateModel();
    }

    IngestDocument(IngestCtxMap ctxMap, Map<String, Object> ingestMetadata) {
        this.ctxMap = Objects.requireNonNull(ctxMap);
        this.ingestMetadata = Objects.requireNonNull(ingestMetadata);
        this.templateModel = this.initializeTemplateModel();
    }

    private DelegatingMapView initializeTemplateModel() {
        return new DelegatingMapView(this.ctxMap, Map.of(SOURCE_KEY, this.ctxMap, INGEST_KEY, this.ingestMetadata));
    }

    public <T> T getFieldValue(String path, Class<T> clazz) {
        return this.getFieldValue(path, clazz, false);
    }

    public <T> T getFieldValue(String path, Class<T> clazz, boolean ignoreMissing) {
        FieldPath fieldPath = FieldPath.of(path, this.getCurrentAccessPatternSafe());
        Object context = fieldPath.initialContext(this);
        ResolveResult result = IngestDocument.resolve(fieldPath.pathElements, fieldPath.pathElements.length, path, context, this.getCurrentAccessPatternSafe());
        if (result.wasSuccessful) {
            return IngestDocument.cast(path, result.resolvedObject, clazz);
        }
        if (ignoreMissing) {
            return null;
        }
        throw new IllegalArgumentException(Objects.requireNonNullElseGet(result.errorMessage, () -> Errors.notPresent(path, result.missingFields)));
    }

    public byte[] getFieldValueAsBytes(String path) {
        return this.getFieldValueAsBytes(path, false);
    }

    public byte[] getFieldValueAsBytes(String path, boolean ignoreMissing) {
        Object object = this.getFieldValue(path, Object.class, ignoreMissing);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return bytes;
        }
        if (object instanceof String) {
            String string = (String)object;
            return Base64.getDecoder().decode(string);
        }
        throw new IllegalArgumentException(Errors.notStringOrByteArray(path, object));
    }

    public boolean hasField(String path) {
        return this.hasField(path, false);
    }

    public boolean hasField(String path, boolean failOutOfRange) {
        List list;
        FieldPath fieldPath = FieldPath.of(path, this.getCurrentAccessPatternSafe());
        Object context = fieldPath.initialContext(this);
        int leafKeyIndex = fieldPath.pathElements.length - 1;
        int lastContainerIndex = fieldPath.pathElements.length - 2;
        Object leafKey = fieldPath.pathElements[leafKeyIndex];
        for (int i = 0; i <= lastContainerIndex; ++i) {
            String pathElement = fieldPath.pathElements[i];
            if (context == null) {
                return false;
            }
            if (context instanceof IngestCtxMap) {
                IngestCtxMap map = (IngestCtxMap)context;
                switch (this.getCurrentAccessPatternSafe()) {
                    case CLASSIC: {
                        context = map.get(pathElement);
                        break;
                    }
                    case FLEXIBLE: {
                        Object object = map.getOrDefault((Object)pathElement, NOT_FOUND);
                        if (object != NOT_FOUND) {
                            context = object;
                            break;
                        }
                        if (i == lastContainerIndex) {
                            leafKey = pathElement + "." + (String)leafKey;
                            break;
                        }
                        Object combinedPath = pathElement;
                        for (int j = i + 1; j <= lastContainerIndex; ++j) {
                            object = map.getOrDefault(combinedPath = (String)combinedPath + "." + fieldPath.pathElements[j], NOT_FOUND);
                            if (object == NOT_FOUND) continue;
                            context = object;
                            i = j;
                            break;
                        }
                        if (object != NOT_FOUND) break;
                        leafKey = (String)combinedPath + "." + (String)leafKey;
                        i = lastContainerIndex;
                    }
                }
                continue;
            }
            if (context instanceof Map) {
                Map map = (Map)context;
                switch (this.getCurrentAccessPatternSafe()) {
                    case CLASSIC: {
                        context = map.get(pathElement);
                        break;
                    }
                    case FLEXIBLE: {
                        Map typedMap = (Map)context;
                        Object object = typedMap.getOrDefault(pathElement, NOT_FOUND);
                        if (object != NOT_FOUND) {
                            context = object;
                            break;
                        }
                        if (i == lastContainerIndex) {
                            leafKey = pathElement + "." + (String)leafKey;
                            break;
                        }
                        Object combinedPath = pathElement;
                        for (int j = i + 1; j <= lastContainerIndex; ++j) {
                            object = typedMap.getOrDefault(combinedPath = (String)combinedPath + "." + fieldPath.pathElements[j], NOT_FOUND);
                            if (object == NOT_FOUND) continue;
                            context = object;
                            i = j;
                            break;
                        }
                        if (object != NOT_FOUND) break;
                        leafKey = (String)combinedPath + "." + (String)leafKey;
                        i = lastContainerIndex;
                    }
                }
                continue;
            }
            if (context instanceof List) {
                int index;
                list = (List)context;
                if (this.getCurrentAccessPatternSafe() == IngestPipelineFieldAccessPattern.FLEXIBLE) {
                    return false;
                }
                try {
                    index = Integer.parseInt(pathElement);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (index < 0 || index >= list.size()) {
                    if (failOutOfRange) {
                        throw new IllegalArgumentException(Errors.outOfBounds(path, index, list.size()));
                    }
                    return false;
                }
                context = list.get(index);
                continue;
            }
            return false;
        }
        if (context == null) {
            return false;
        }
        if (context instanceof IngestCtxMap) {
            IngestCtxMap map = (IngestCtxMap)context;
            return map.containsKey(leafKey);
        }
        if (context instanceof Map) {
            Map map = (Map)context;
            return map.containsKey(leafKey);
        }
        if (context instanceof List) {
            list = (List)context;
            if (this.getCurrentAccessPatternSafe() == IngestPipelineFieldAccessPattern.FLEXIBLE) {
                return false;
            }
            try {
                int index = Integer.parseInt((String)leafKey);
                if (index >= 0 && index < list.size()) {
                    return true;
                }
                if (failOutOfRange) {
                    throw new IllegalArgumentException(Errors.outOfBounds(path, index, list.size()));
                }
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public void removeField(String path) {
        this.removeField(path, false);
    }

    public void removeField(String path, boolean ignoreMissing) {
        FieldPath fieldPath = FieldPath.of(path, this.getCurrentAccessPatternSafe());
        Object context = fieldPath.initialContext(this);
        Object leafKey = fieldPath.pathElements[fieldPath.pathElements.length - 1];
        ResolveResult result = IngestDocument.resolve(fieldPath.pathElements, fieldPath.pathElements.length - 1, path, context, this.getCurrentAccessPatternSafe());
        if (result.wasSuccessful) {
            context = result.resolvedObject;
        } else if (result.missingFields != null) {
            leafKey = result.missingFields + "." + (String)leafKey;
            context = result.resolvedObject;
        } else {
            if (ignoreMissing) {
                return;
            }
            throw new IllegalArgumentException(result.errorMessage);
        }
        if (context == null && !ignoreMissing) {
            throw new IllegalArgumentException(Errors.cannotRemove(path, (String)leafKey, null));
        }
        if (context instanceof IngestCtxMap) {
            IngestCtxMap map = (IngestCtxMap)context;
            if (map.containsKey(leafKey)) {
                map.remove(leafKey);
            } else if (!ignoreMissing) {
                throw new IllegalArgumentException(Errors.notPresent(path, (String)leafKey));
            }
        } else if (context instanceof Map) {
            Map map = (Map)context;
            if (map.containsKey(leafKey)) {
                map.remove(leafKey);
            } else if (!ignoreMissing) {
                throw new IllegalArgumentException(Errors.notPresent(path, (String)leafKey));
            }
        } else if (context instanceof List) {
            int index;
            List list;
            block26: {
                list = (List)context;
                if (this.getCurrentAccessPatternSafe() == IngestPipelineFieldAccessPattern.FLEXIBLE) {
                    if (!ignoreMissing) {
                        throw new IllegalArgumentException("path [" + path + "] is not valid");
                    }
                    return;
                }
                index = -1;
                try {
                    index = Integer.parseInt((String)leafKey);
                }
                catch (NumberFormatException e) {
                    if (ignoreMissing) break block26;
                    throw new IllegalArgumentException(Errors.notInteger(path, (String)leafKey), e);
                }
            }
            if (index < 0 || index >= list.size()) {
                if (!ignoreMissing) {
                    throw new IllegalArgumentException(Errors.outOfBounds(path, index, list.size()));
                }
            } else {
                list.remove(index);
            }
        } else if (!ignoreMissing) {
            throw new IllegalArgumentException(Errors.cannotRemove(path, (String)leafKey, context));
        }
    }

    private static ResolveResult resolve(String[] pathElements, int limit, String fullPath, Object context, IngestPipelineFieldAccessPattern accessPattern) {
        for (int i = 0; i < limit; ++i) {
            String pathElement = pathElements[i];
            if (context == null) {
                return ResolveResult.error(Errors.cannotResolve(fullPath, pathElement, null));
            }
            if (context instanceof IngestCtxMap) {
                IngestCtxMap map = (IngestCtxMap)context;
                switch (accessPattern) {
                    case CLASSIC: {
                        Object object = map.getOrDefault((Object)pathElement, NOT_FOUND);
                        if (object == NOT_FOUND) {
                            return ResolveResult.error(Errors.notPresent(fullPath, pathElement));
                        }
                        context = object;
                        break;
                    }
                    case FLEXIBLE: {
                        Object object = map.getOrDefault((Object)pathElement, NOT_FOUND);
                        if (object != NOT_FOUND) {
                            context = object;
                            break;
                        }
                        if (i == limit - 1) {
                            return ResolveResult.incomplete(context, pathElement);
                        }
                        Object combinedPath = pathElement;
                        for (int j = i + 1; j < limit; ++j) {
                            object = map.getOrDefault(combinedPath = (String)combinedPath + "." + pathElements[j], NOT_FOUND);
                            if (object == NOT_FOUND) continue;
                            context = object;
                            i = j;
                            break;
                        }
                        if (object != NOT_FOUND) break;
                        return ResolveResult.incomplete(context, (String)combinedPath);
                    }
                }
                continue;
            }
            if (context instanceof Map) {
                switch (accessPattern) {
                    case CLASSIC: {
                        Map map = (Map)context;
                        Object object = map.getOrDefault(pathElement, NOT_FOUND);
                        if (object == NOT_FOUND) {
                            return ResolveResult.error(Errors.notPresent(fullPath, pathElement));
                        }
                        context = object;
                        break;
                    }
                    case FLEXIBLE: {
                        Map map = (Map)context;
                        Object object = map.getOrDefault(pathElement, NOT_FOUND);
                        if (object != NOT_FOUND) {
                            context = object;
                            break;
                        }
                        if (i == limit - 1) {
                            return ResolveResult.incomplete(context, pathElement);
                        }
                        Object combinedPath = pathElement;
                        for (int j = i + 1; j < limit; ++j) {
                            object = map.getOrDefault(combinedPath = (String)combinedPath + "." + pathElements[j], NOT_FOUND);
                            if (object == NOT_FOUND) continue;
                            context = object;
                            i = j;
                            break;
                        }
                        if (object != NOT_FOUND) break;
                        return ResolveResult.incomplete(context, (String)combinedPath);
                    }
                }
                continue;
            }
            if (context instanceof List) {
                int index;
                List list = (List)context;
                if (accessPattern == IngestPipelineFieldAccessPattern.FLEXIBLE) {
                    return ResolveResult.error(Errors.invalidPath(fullPath));
                }
                try {
                    index = Integer.parseInt(pathElement);
                }
                catch (NumberFormatException e) {
                    return ResolveResult.error(Errors.notInteger(fullPath, pathElement));
                }
                if (index < 0 || index >= list.size()) {
                    return ResolveResult.error(Errors.outOfBounds(fullPath, index, list.size()));
                }
                context = list.get(index);
                continue;
            }
            return ResolveResult.error(Errors.cannotResolve(fullPath, pathElement, context));
        }
        return ResolveResult.success(context);
    }

    public void appendFieldValue(String path, Object value) {
        this.appendFieldValue(path, value, true);
    }

    public void appendFieldValue(String path, Object value, boolean allowDuplicates) {
        this.setFieldValue(path, value, true, allowDuplicates, false);
    }

    public void appendFieldValue(String path, Object value, boolean allowDuplicates, boolean ignoreEmptyValues) {
        this.setFieldValue(path, value, true, allowDuplicates, ignoreEmptyValues);
    }

    public void appendFieldValue(String path, ValueSource valueSource, boolean allowDuplicates, boolean ignoreEmptyValues) {
        this.appendFieldValue(path, valueSource.copyAndResolve(this.templateModel), allowDuplicates, ignoreEmptyValues);
    }

    public void setFieldValue(String path, Object value) {
        this.setFieldValue(path, value, false, false, false);
    }

    public void setFieldValue(String path, ValueSource valueSource) {
        this.setFieldValue(path, valueSource.copyAndResolve(this.templateModel));
    }

    public void setFieldValue(String path, ValueSource valueSource, boolean ignoreEmptyValue) {
        Object value = valueSource.copyAndResolve(this.templateModel);
        if (valueSource instanceof ValueSource.TemplatedValue) {
            if (!ignoreEmptyValue || IngestDocument.valueNotEmpty(value)) {
                this.setFieldValue(path, value);
            }
        } else {
            this.setFieldValue(path, value);
        }
    }

    public void setFieldValue(String path, Object value, boolean ignoreEmptyValue) {
        if (!ignoreEmptyValue || IngestDocument.valueNotEmpty(value)) {
            this.setFieldValue(path, value);
        }
    }

    private void setFieldValue(String path, Object value, boolean append, boolean allowDuplicates, boolean ignoreEmptyValues) {
        Object list;
        assert (append || !allowDuplicates && !ignoreEmptyValues) : "allowDuplicates and ignoreEmptyValues only apply if append is true";
        FieldPath fieldPath = FieldPath.of(path, this.getCurrentAccessPatternSafe());
        Object context = fieldPath.initialContext(this);
        int leafKeyIndex = fieldPath.pathElements.length - 1;
        int lastContainerIndex = fieldPath.pathElements.length - 2;
        Object leafKey = fieldPath.pathElements[leafKeyIndex];
        for (int i = 0; i <= lastContainerIndex; ++i) {
            String pathElement = fieldPath.pathElements[i];
            if (context == null) {
                throw new IllegalArgumentException(Errors.cannotResolve(path, pathElement, null));
            }
            if (context instanceof IngestCtxMap) {
                IngestCtxMap map = (IngestCtxMap)context;
                switch (this.getCurrentAccessPatternSafe()) {
                    case CLASSIC: {
                        Object object = map.getOrDefault((Object)pathElement, NOT_FOUND);
                        if (object == NOT_FOUND) {
                            HashMap newMap = new HashMap();
                            map.put(pathElement, (Object)newMap);
                            context = newMap;
                            break;
                        }
                        context = object;
                        break;
                    }
                    case FLEXIBLE: {
                        Object object = map.getOrDefault((Object)pathElement, NOT_FOUND);
                        if (object != NOT_FOUND) {
                            context = object;
                            break;
                        }
                        if (i == lastContainerIndex) {
                            leafKey = pathElement + "." + (String)leafKey;
                            break;
                        }
                        Object combinedPath = pathElement;
                        for (int j = i + 1; j <= lastContainerIndex; ++j) {
                            object = map.getOrDefault(combinedPath = (String)combinedPath + "." + fieldPath.pathElements[j], NOT_FOUND);
                            if (object == NOT_FOUND) continue;
                            context = object;
                            i = j;
                            break;
                        }
                        if (object != NOT_FOUND) break;
                        leafKey = (String)combinedPath + "." + (String)leafKey;
                        i = lastContainerIndex;
                    }
                }
                continue;
            }
            if (context instanceof Map) {
                switch (this.getCurrentAccessPatternSafe()) {
                    case CLASSIC: {
                        Map map = (Map)context;
                        Object object = map.getOrDefault(pathElement, NOT_FOUND);
                        if (object == NOT_FOUND) {
                            HashMap newMap = new HashMap();
                            map.put(pathElement, newMap);
                            context = newMap;
                            break;
                        }
                        context = object;
                        break;
                    }
                    case FLEXIBLE: {
                        Map map = (Map)context;
                        Object object = map.getOrDefault(pathElement, NOT_FOUND);
                        if (object != NOT_FOUND) {
                            context = object;
                            break;
                        }
                        if (i == lastContainerIndex) {
                            leafKey = pathElement + "." + (String)leafKey;
                            break;
                        }
                        Object combinedPath = pathElement;
                        for (int j = i + 1; j <= lastContainerIndex; ++j) {
                            object = map.getOrDefault(combinedPath = (String)combinedPath + "." + fieldPath.pathElements[j], NOT_FOUND);
                            if (object == NOT_FOUND) continue;
                            context = object;
                            i = j;
                            break;
                        }
                        if (object != NOT_FOUND) break;
                        leafKey = (String)combinedPath + "." + (String)leafKey;
                        i = lastContainerIndex;
                    }
                }
                continue;
            }
            if (context instanceof List) {
                int index;
                list = (ArrayList)context;
                if (this.getCurrentAccessPatternSafe() == IngestPipelineFieldAccessPattern.FLEXIBLE) {
                    throw new IllegalArgumentException("path [" + path + "] is not valid");
                }
                try {
                    index = Integer.parseInt(pathElement);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(Errors.notInteger(path, pathElement), e);
                }
                if (index < 0 || index >= list.size()) {
                    throw new IllegalArgumentException(Errors.outOfBounds(path, index, list.size()));
                }
                context = list.get(index);
                continue;
            }
            throw new IllegalArgumentException(Errors.cannotResolve(path, pathElement, context));
        }
        if (context == null) {
            throw new IllegalArgumentException(Errors.cannotSet(path, (String)leafKey, null));
        }
        if (context instanceof IngestCtxMap) {
            IngestCtxMap map = (IngestCtxMap)context;
            if (append) {
                Object object = map.getOrDefault(leafKey, NOT_FOUND);
                if (object == NOT_FOUND) {
                    list = new ArrayList();
                    IngestDocument.appendValues(list, value, allowDuplicates, ignoreEmptyValues);
                    map.put((String)leafKey, list);
                } else {
                    list = IngestDocument.appendValues(object, value, allowDuplicates, ignoreEmptyValues);
                    if (list != object) {
                        map.put((String)leafKey, list);
                    }
                }
                return;
            }
            map.put((String)leafKey, value);
        } else if (context instanceof Map) {
            Map map = (Map)context;
            if (append) {
                Object object = map.getOrDefault(leafKey, NOT_FOUND);
                if (object == NOT_FOUND) {
                    list = new ArrayList();
                    IngestDocument.appendValues(list, value, allowDuplicates, ignoreEmptyValues);
                    map.put(leafKey, list);
                } else {
                    list = IngestDocument.appendValues(object, value, allowDuplicates, ignoreEmptyValues);
                    if (list != object) {
                        map.put(leafKey, list);
                    }
                }
                return;
            }
            map.put(leafKey, value);
        } else if (context instanceof List) {
            int index;
            if (this.getCurrentAccessPatternSafe() == IngestPipelineFieldAccessPattern.FLEXIBLE) {
                throw new IllegalArgumentException("path [" + path + "] is not valid");
            }
            List list2 = (List)context;
            try {
                index = Integer.parseInt((String)leafKey);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(Errors.notInteger(path, (String)leafKey), e);
            }
            if (index < 0 || index >= list2.size()) {
                throw new IllegalArgumentException(Errors.outOfBounds(path, index, list2.size()));
            }
            if (append) {
                Object object = list2.get(index);
                Object newList = IngestDocument.appendValues(object, value, allowDuplicates, ignoreEmptyValues);
                if (newList != object) {
                    list2.set(index, newList);
                }
                return;
            }
            list2.set(index, value);
        } else {
            throw new IllegalArgumentException(Errors.cannotSet(path, (String)leafKey, context));
        }
    }

    private static Object appendValues(Object maybeList, Object value, boolean allowDuplicates, boolean ignoreEmptyValues) {
        ArrayList<Object> list;
        if (maybeList instanceof List) {
            list = (ArrayList<Object>)maybeList;
        } else {
            list = new ArrayList<Object>();
            list.add(maybeList);
        }
        if (allowDuplicates) {
            IngestDocument.innerAppendValues(list, value, ignoreEmptyValues);
            return list;
        }
        return IngestDocument.innerAppendValuesWithoutDuplicates(list, value, ignoreEmptyValues) ? list : maybeList;
    }

    private static void innerAppendValues(List<Object> list, Object value, boolean ignoreEmptyValues) {
        if (value instanceof List) {
            List l = (List)value;
            if (ignoreEmptyValues) {
                l.forEach(v -> {
                    if (IngestDocument.valueNotEmpty(v)) {
                        list.add(v);
                    }
                });
            } else {
                list.addAll(l);
            }
        } else if (!ignoreEmptyValues || IngestDocument.valueNotEmpty(value)) {
            list.add(value);
        }
    }

    private static boolean innerAppendValuesWithoutDuplicates(List<Object> list, Object value, boolean ignoreEmptyValues) {
        boolean valuesWereAppended = false;
        if (value instanceof List) {
            List valueList = (List)value;
            for (Object val : valueList) {
                if (list.contains(val) || ignoreEmptyValues && !IngestDocument.valueNotEmpty(val)) continue;
                list.add(val);
                valuesWereAppended = true;
            }
        } else if (!(list.contains(value) || ignoreEmptyValues && !IngestDocument.valueNotEmpty(value))) {
            list.add(value);
            valuesWereAppended = true;
        }
        return valuesWereAppended;
    }

    private static boolean valueNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String string = (String)value;
            return !string.isEmpty();
        }
        return true;
    }

    private static <T> T cast(String path, Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw new IllegalArgumentException(Errors.cannotCast(path, object, clazz));
    }

    public String renderTemplate(TemplateScript.Factory template) {
        return template.newInstance(this.templateModel).execute();
    }

    public Map<String, Object> getSourceAndMetadata() {
        return this.ctxMap;
    }

    public Map<String, Object> getUnmodifiableSourceAndMetadata() {
        return new UnmodifiableIngestData(this.ctxMap);
    }

    public CtxMap<?> getCtxMap() {
        return this.ctxMap;
    }

    public org.elasticsearch.script.Metadata getMetadata() {
        return this.ctxMap.getMetadata();
    }

    public Map<String, Object> getSource() {
        return this.ctxMap.getSource();
    }

    public Map<String, Object> getIngestMetadata() {
        return this.ingestMetadata;
    }

    public static <K, V> Map<K, V> deepCopyMap(Map<K, V> source) {
        return (Map)IngestDocument.deepCopy(source);
    }

    public static Object deepCopy(Object value) {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            Map copy = Maps.newMapWithExpectedSize(mapValue.size());
            for (Map.Entry entry : mapValue.entrySet()) {
                copy.put(entry.getKey(), IngestDocument.deepCopy(entry.getValue()));
            }
            return copy;
        }
        if (value instanceof List) {
            List listValue = (List)value;
            ArrayList<Object> copy = new ArrayList<Object>(listValue.size());
            for (Object itemValue : listValue) {
                copy.add(IngestDocument.deepCopy(itemValue));
            }
            return copy;
        }
        if (value instanceof Set) {
            Set setValue = (Set)value;
            HashSet<Object> copy = Sets.newHashSetWithExpectedSize(setValue.size());
            for (Object itemValue : setValue) {
                copy.add(IngestDocument.deepCopy(itemValue));
            }
            return copy;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return Arrays.copyOf(bytes, bytes.length);
        }
        if (value instanceof double[][]) {
            double[][] doubles = (double[][])value;
            double[][] result = new double[doubles.length][];
            for (int i = 0; i < doubles.length; ++i) {
                result[i] = Arrays.copyOf(doubles[i], doubles[i].length);
            }
            return result;
        }
        if (value instanceof double[]) {
            double[] doubles = (double[])value;
            return Arrays.copyOf(doubles, doubles.length);
        }
        if (value == null || value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Boolean || value instanceof ZonedDateTime) {
            return value;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return date.clone();
        }
        throw new IllegalArgumentException("unexpected value type [" + String.valueOf(value.getClass()) + "]");
    }

    public static Set<String> getAllFields(Map<String, Object> input) {
        return IngestDocument.getAllFields(input, "");
    }

    private static Set<String> getAllFields(Map<String, Object> input, String prefix) {
        HashSet<String> allFields = Sets.newHashSet(new String[0]);
        input.forEach((k, v) -> {
            allFields.add(prefix + k);
            if (v instanceof Map) {
                Map mapValue = (Map)v;
                allFields.addAll(IngestDocument.getAllFields(mapValue, prefix + k + "."));
            }
        });
        return allFields;
    }

    public void executePipeline(Pipeline pipeline, BiConsumer<IngestDocument, Exception> handler) {
        if (pipeline.getProcessors().isEmpty()) {
            handler.accept(this, null);
            return;
        }
        if (this.executedPipelines.size() >= MAX_PIPELINES) {
            handler.accept(null, new GraphStructureException("Too many nested pipelines. Cannot have more than " + MAX_PIPELINES + " nested pipelines"));
        } else if (this.executedPipelines.add(pipeline.getId())) {
            Object previousPipeline = this.ingestMetadata.put("pipeline", pipeline.getId());
            IngestPipelineFieldAccessPattern previousAccessPattern = this.accessPatternStack.peek();
            this.accessPatternStack.push(pipeline.getFieldAccessPattern());
            pipeline.execute(this, (result, e) -> {
                this.executedPipelines.remove(pipeline.getId());
                this.accessPatternStack.poll();
                assert (previousAccessPattern == this.accessPatternStack.peek()) : "Cleared access pattern from nested pipeline and found inconsistent stack state. Expected [" + String.valueOf((Object)previousAccessPattern) + "] but found [" + String.valueOf((Object)this.accessPatternStack.peek()) + "]";
                if (previousPipeline != null) {
                    this.ingestMetadata.put("pipeline", previousPipeline);
                } else {
                    this.ingestMetadata.remove("pipeline");
                }
                handler.accept((IngestDocument)result, (Exception)e);
            });
        } else {
            handler.accept(null, new GraphStructureException(PIPELINE_CYCLE_ERROR_MESSAGE + pipeline.getId()));
        }
    }

    List<String> getPipelineStack() {
        ArrayList<String> pipelineStack = new ArrayList<String>(this.executedPipelines);
        Collections.reverse(pipelineStack);
        return pipelineStack;
    }

    public Optional<IngestPipelineFieldAccessPattern> getCurrentAccessPattern() {
        return Optional.ofNullable(this.accessPatternStack.peek());
    }

    public IngestPipelineFieldAccessPattern getCurrentAccessPatternSafe() {
        return this.getCurrentAccessPattern().orElse(IngestPipelineFieldAccessPattern.CLASSIC);
    }

    public boolean updateIndexHistory(String index) {
        return this.indexHistory.add(index);
    }

    public Set<String> getIndexHistory() {
        return Collections.unmodifiableSet(this.indexHistory);
    }

    public boolean doNoSelfReferencesCheck() {
        return this.doNoSelfReferencesCheck;
    }

    public void doNoSelfReferencesCheck(boolean doNoSelfReferencesCheck) {
        this.doNoSelfReferencesCheck = doNoSelfReferencesCheck;
    }

    public String toString() {
        return "IngestDocument{ sourceAndMetadata=" + String.valueOf(this.ctxMap) + ", ingestMetadata=" + String.valueOf(this.ingestMetadata) + "}";
    }

    public void reroute(String destIndex) {
        this.getMetadata().setIndex(destIndex);
        this.reroute = true;
    }

    boolean isReroute() {
        return this.reroute;
    }

    void resetReroute() {
        this.reroute = false;
    }

    public void terminate() {
        this.terminate = true;
    }

    boolean isTerminate() {
        return this.terminate;
    }

    void resetTerminate() {
        this.terminate = false;
    }

    private static Object wrapUnmodifiable(Object raw) {
        if (raw instanceof Map) {
            Map rawMap = (Map)raw;
            return new UnmodifiableIngestData(rawMap);
        }
        if (raw instanceof List) {
            return new UnmodifiableIngestList((List)raw);
        }
        if (raw instanceof Set) {
            Set rawSet = (Set)raw;
            return new UnmodifiableIngestSet(rawSet);
        }
        if (raw instanceof byte[]) {
            byte[] bytes = (byte[])raw;
            return bytes.clone();
        }
        return raw;
    }

    private static UnsupportedOperationException unmodifiableException() {
        return new UnsupportedOperationException("Mutating ingest documents in conditionals is not supported");
    }

    private record DelegatingMapView(Map<String, Object> primary, Map<String, Object> overrides) implements Map<String, Object>
    {
        @Override
        public boolean containsKey(Object key) {
            return this.primary.containsKey(key) || this.overrides.containsKey(key);
        }

        @Override
        public Object get(Object key) {
            Object result = this.overrides.get(key);
            return result != null ? result : this.primary.get(key);
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Metadata {
        INDEX("_index"),
        TYPE("_type"),
        ID("_id"),
        ROUTING("_routing"),
        VERSION("_version"),
        VERSION_TYPE("_version_type"),
        IF_SEQ_NO("_if_seq_no"),
        IF_PRIMARY_TERM("_if_primary_term"),
        DYNAMIC_TEMPLATES("_dynamic_templates");

        private static final Set<String> METADATA_NAMES;
        private final String fieldName;

        private Metadata(String fieldName) {
            this.fieldName = fieldName;
        }

        public static boolean isMetadata(String field) {
            return METADATA_NAMES.contains(field);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        static {
            METADATA_NAMES = Arrays.stream(Metadata.values()).map(metadata -> metadata.fieldName).collect(Collectors.toSet());
        }
    }

    private static final class FieldPath {
        private static final int MAX_SIZE = 512;
        private static final Map<CacheKey, FieldPath> CACHE = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
        private final String[] pathElements;
        private final boolean useIngestContext;

        static FieldPath of(String path, IngestPipelineFieldAccessPattern accessPattern) {
            if (Strings.isEmpty(path)) {
                throw new IllegalArgumentException("path cannot be null nor empty");
            }
            CacheKey cacheKey = new CacheKey(path, accessPattern);
            FieldPath res = CACHE.get(cacheKey);
            if (res != null) {
                return res;
            }
            res = new FieldPath(path, accessPattern);
            if (CACHE.size() > 512) {
                CACHE.clear();
            }
            CACHE.put(cacheKey, res);
            return res;
        }

        private FieldPath(String path, IngestPipelineFieldAccessPattern accessPattern) {
            String newPath;
            if (path.startsWith(IngestDocument.INGEST_KEY_PREFIX)) {
                this.useIngestContext = true;
                newPath = path.substring(IngestDocument.INGEST_KEY_PREFIX.length());
            } else {
                this.useIngestContext = false;
                newPath = path.startsWith(IngestDocument.SOURCE_PREFIX) ? path.substring(IngestDocument.SOURCE_PREFIX.length()) : path;
            }
            String[] pathParts = newPath.split("\\.");
            this.pathElements = FieldPath.processPathParts(path, pathParts, accessPattern);
        }

        private static String[] processPathParts(String fullPath, String[] pathParts, IngestPipelineFieldAccessPattern accessPattern) {
            return switch (accessPattern) {
                default -> throw new MatchException(null, null);
                case IngestPipelineFieldAccessPattern.CLASSIC -> FieldPath.validateClassicFields(fullPath, pathParts);
                case IngestPipelineFieldAccessPattern.FLEXIBLE -> FieldPath.parseFlexibleFields(fullPath, pathParts);
            };
        }

        private static String[] validateClassicFields(String fullPath, String[] pathParts) {
            for (String pathPart : pathParts) {
                if (!pathPart.isEmpty()) continue;
                throw new IllegalArgumentException("path [" + fullPath + "] is not valid");
            }
            return pathParts;
        }

        private static String[] parseFlexibleFields(String fullPath, String[] pathParts) {
            for (String pathPart : pathParts) {
                if (!pathPart.isEmpty() && !pathPart.contains("[") && !pathPart.contains("]")) continue;
                throw new IllegalArgumentException("path [" + fullPath + "] is not valid");
            }
            return pathParts;
        }

        public Object initialContext(IngestDocument document) {
            return this.useIngestContext ? document.getIngestMetadata() : document.getCtxMap();
        }

        private record CacheKey(String path, IngestPipelineFieldAccessPattern accessPattern) {
        }
    }

    private record ResolveResult(boolean wasSuccessful, Object resolvedObject, String errorMessage, String missingFields) {
        static ResolveResult success(Object resolvedObject) {
            return new ResolveResult(true, resolvedObject, null, null);
        }

        static ResolveResult incomplete(Object lastResolvedObject, String missingFields) {
            return new ResolveResult(false, lastResolvedObject, null, missingFields);
        }

        static ResolveResult error(String errorMessage) {
            return new ResolveResult(false, null, errorMessage, null);
        }
    }

    private static final class Errors {
        private Errors() {
        }

        private static String cannotCast(String path, Object value, Class<?> clazz) {
            return "field [" + path + "] of type [" + value.getClass().getName() + "] cannot be cast to [" + clazz.getName() + "]";
        }

        private static String cannotRemove(String path, String key, Object value) {
            if (value == null) {
                return "cannot remove [" + key + "] from null as part of path [" + path + "]";
            }
            String type = value.getClass().getName();
            return "cannot remove [" + key + "] from object of type [" + type + "] as part of path [" + path + "]";
        }

        private static String cannotResolve(String path, String key, Object value) {
            if (value == null) {
                return "cannot resolve [" + key + "] from null as part of path [" + path + "]";
            }
            String type = value.getClass().getName();
            return "cannot resolve [" + key + "] from object of type [" + type + "] as part of path [" + path + "]";
        }

        private static String cannotSet(String path, String key, Object value) {
            if (value == null) {
                return "cannot set [" + key + "] with null parent as part of path [" + path + "]";
            }
            String type = value.getClass().getName();
            return "cannot set [" + key + "] with parent object of type [" + type + "] as part of path [" + path + "]";
        }

        private static String outOfBounds(String path, int index, int length) {
            return "[" + index + "] is out of bounds for array with length [" + length + "] as part of path [" + path + "]";
        }

        private static String notInteger(String path, String key) {
            return "[" + key + "] is not an integer, cannot be used as an index as part of path [" + path + "]";
        }

        private static String notPresent(String path, String key) {
            return "field [" + key + "] not present as part of path [" + path + "]";
        }

        private static String notStringOrByteArray(String path, Object value) {
            return "Content field [" + path + "] of unknown type [" + value.getClass().getName() + "], must be string or byte array";
        }

        private static String invalidPath(String fullPath) {
            return "path [" + fullPath + "] is not valid";
        }
    }

    private static final class UnmodifiableIngestData
    implements Map<String, Object> {
        private final Map<String, Object> data;

        UnmodifiableIngestData(Map<String, Object> data) {
            this.data = data;
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.data.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.data.containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return IngestDocument.wrapUnmodifiable(this.data.get(key));
        }

        @Override
        public Object put(String key, Object value) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public Object remove(Object key) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public void clear() {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public Set<String> keySet() {
            return Collections.unmodifiableSet(this.data.keySet());
        }

        @Override
        public Collection<Object> values() {
            return new UnmodifiableIngestList(new ArrayList<Object>(this.data.values()));
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.data.entrySet().stream().map(entry -> new Map.Entry<String, Object>(){

                @Override
                public String getKey() {
                    return (String)entry.getKey();
                }

                @Override
                public Object getValue() {
                    return IngestDocument.wrapUnmodifiable(entry.getValue());
                }

                @Override
                public Object setValue(Object value) {
                    throw IngestDocument.unmodifiableException();
                }

                @Override
                public boolean equals(Object o) {
                    return entry.equals(o);
                }

                @Override
                public int hashCode() {
                    return entry.hashCode();
                }
            }).collect(Collectors.toSet());
        }
    }

    private static final class UnmodifiableIngestList
    implements List<Object> {
        private final List<Object> data;

        UnmodifiableIngestList(List<Object> data) {
            this.data = data;
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.data.contains(o);
        }

        @Override
        public Iterator<Object> iterator() {
            return new UnmodifiableIterator(this.data.iterator());
        }

        @Override
        public Object[] toArray() {
            Object[] wrapped = this.data.toArray(new Object[0]);
            for (int i = 0; i < wrapped.length; ++i) {
                wrapped[i] = IngestDocument.wrapUnmodifiable(wrapped[i]);
            }
            return wrapped;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] raw = this.data.toArray(new Object[0]);
            T[] wrapped = Arrays.copyOf(raw, a.length, a.getClass());
            for (int i = 0; i < wrapped.length; ++i) {
                wrapped[i] = IngestDocument.wrapUnmodifiable(wrapped[i]);
            }
            return wrapped;
        }

        @Override
        public boolean add(Object o) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public boolean remove(Object o) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.data.contains(c);
        }

        @Override
        public boolean addAll(Collection<?> c) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public boolean addAll(int index, Collection<?> c) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public void clear() {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public Object get(int index) {
            return IngestDocument.wrapUnmodifiable(this.data.get(index));
        }

        @Override
        public Object set(int index, Object element) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public void add(int index, Object element) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public Object remove(int index) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public int indexOf(Object o) {
            return this.data.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.data.lastIndexOf(o);
        }

        @Override
        public ListIterator<Object> listIterator() {
            return new UnmodifiableListIterator(this.data.listIterator());
        }

        @Override
        public ListIterator<Object> listIterator(int index) {
            return new UnmodifiableListIterator(this.data.listIterator(index));
        }

        @Override
        public List<Object> subList(int fromIndex, int toIndex) {
            return new UnmodifiableIngestList(this.data.subList(fromIndex, toIndex));
        }

        private static final class UnmodifiableListIterator
        implements ListIterator<Object> {
            private final ListIterator<Object> data;

            UnmodifiableListIterator(ListIterator<Object> data) {
                this.data = data;
            }

            @Override
            public boolean hasNext() {
                return this.data.hasNext();
            }

            @Override
            public Object next() {
                return IngestDocument.wrapUnmodifiable(this.data.next());
            }

            @Override
            public boolean hasPrevious() {
                return this.data.hasPrevious();
            }

            @Override
            public Object previous() {
                return IngestDocument.wrapUnmodifiable(this.data.previous());
            }

            @Override
            public int nextIndex() {
                return this.data.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.data.previousIndex();
            }

            @Override
            public void remove() {
                throw IngestDocument.unmodifiableException();
            }

            @Override
            public void set(Object o) {
                throw IngestDocument.unmodifiableException();
            }

            @Override
            public void add(Object o) {
                throw IngestDocument.unmodifiableException();
            }
        }
    }

    private static final class UnmodifiableIngestSet
    implements Set<Object> {
        private final Set<Object> data;

        UnmodifiableIngestSet(Set<Object> data) {
            this.data = data;
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.data.contains(o);
        }

        @Override
        public Iterator<Object> iterator() {
            return new UnmodifiableIterator(this.data.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.data.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.data.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public boolean remove(Object o) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.data.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<?> c) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw IngestDocument.unmodifiableException();
        }

        @Override
        public void clear() {
            throw IngestDocument.unmodifiableException();
        }
    }

    private static final class UnmodifiableIterator
    implements Iterator<Object> {
        private final Iterator<Object> it;

        UnmodifiableIterator(Iterator<Object> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Object next() {
            return IngestDocument.wrapUnmodifiable(this.it.next());
        }

        @Override
        public void remove() {
            throw IngestDocument.unmodifiableException();
        }
    }
}

