/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.concurrent.Executor;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThrottledTaskRunner;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

class PostRecoveryMerger {
    private static final Logger logger = LogManager.getLogger(PostRecoveryMerger.class);
    private static final boolean TRIGGER_MERGE_AFTER_RECOVERY;
    private final ThrottledTaskRunner postRecoveryMergeRunner;
    private final Function<ShardId, IndexShard> shardFunction;
    private final boolean enabled;

    PostRecoveryMerger(Settings settings, Executor executor, Function<ShardId, IndexShard> shardFunction) {
        this.postRecoveryMergeRunner = new ThrottledTaskRunner(this.getClass().getCanonicalName(), 1, executor);
        this.shardFunction = shardFunction;
        this.enabled = TRIGGER_MERGE_AFTER_RECOVERY && (DiscoveryNode.hasRole(settings, DiscoveryNodeRole.DATA_HOT_NODE_ROLE) || DiscoveryNode.hasRole(settings, DiscoveryNodeRole.DATA_CONTENT_NODE_ROLE) || DiscoveryNode.hasRole(settings, DiscoveryNodeRole.DATA_ROLE) || DiscoveryNode.hasRole(settings, DiscoveryNodeRole.INDEX_ROLE));
    }

    PeerRecoveryTargetService.RecoveryListener maybeMergeAfterRecovery(IndexMetadata indexMetadata, ShardRouting shardRouting, final PeerRecoveryTargetService.RecoveryListener recoveryListener) {
        if (!this.enabled) {
            return recoveryListener;
        }
        if (!shardRouting.isPromotableToPrimary()) {
            return recoveryListener;
        }
        if (indexMetadata.getCreationVersion().before(IndexVersions.UPGRADE_TO_LUCENE_10_0_0)) {
            return recoveryListener;
        }
        final ShardId shardId = shardRouting.shardId();
        return new PeerRecoveryTargetService.RecoveryListener(){

            @Override
            public void onRecoveryDone(RecoveryState state, ShardLongFieldRange timestampMillisFieldRange, ShardLongFieldRange eventIngestedMillisFieldRange) {
                PostRecoveryMerger.this.postRecoveryMergeRunner.enqueueTask(new PostRecoveryMerge(shardId));
                recoveryListener.onRecoveryDone(state, timestampMillisFieldRange, eventIngestedMillisFieldRange);
            }

            @Override
            public void onRecoveryFailure(RecoveryFailedException e, boolean sendShardFailure) {
                recoveryListener.onRecoveryFailure(e, sendShardFailure);
            }
        };
    }

    static {
        String propertyValue = System.getProperty("es.trigger_merge_after_recovery");
        if (propertyValue == null) {
            TRIGGER_MERGE_AFTER_RECOVERY = true;
        } else if ("false".equals(propertyValue)) {
            TRIGGER_MERGE_AFTER_RECOVERY = false;
        } else {
            throw new IllegalStateException("system property [es.trigger_merge_after_recovery] may only be set to [false], but was [" + propertyValue + "]");
        }
    }

    class PostRecoveryMerge
    implements ActionListener<Releasable> {
        private final ShardId shardId;

        PostRecoveryMerge(ShardId shardId) {
            this.shardId = shardId;
        }

        @Override
        public void onResponse(Releasable releasable) {
            try (Releasable releasable2 = releasable;){
                IndexShard indexShard = PostRecoveryMerger.this.shardFunction.apply(this.shardId);
                if (indexShard == null) {
                    return;
                }
                indexShard.triggerPendingMerges();
            }
            catch (Exception e) {
                this.logFailure(e);
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.logFailure(e);
        }

        private void logFailure(Exception e) {
            logger.debug(() -> Strings.format("failed to execute post-recovery merge of [%s]", this.shardId), (Throwable)e);
        }
    }
}

