/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.elasticsearch.ReleaseVersions;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.Version;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.internal.VersionExtension;
import org.elasticsearch.plugins.ExtensionLoader;

public record TransportVersion(String name, int id, TransportVersion nextPatchVersion) implements VersionId<TransportVersion>
{
    public TransportVersion(int id) {
        this(null, id, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static <T> T parseFromBufferedReader(String component, String path, Function<String, InputStream> nameToStream, BufferedReaderParser<T> parser) {
        try (InputStream inputStream = nameToStream.apply(path);){
            T t;
            if (inputStream == null) {
                T t2 = null;
                return t2;
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                t = parser.parse(component, path, bufferedReader);
            }
            return t;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("parsing error [" + component + ":" + path + "]", ioe);
        }
    }

    public static TransportVersion fromBufferedReader(String component, String path, boolean nameInFile, boolean isNamed, BufferedReader bufferedReader, Integer upperBound) {
        try {
            int i;
            String check;
            String line;
            while ((line = bufferedReader.readLine()).replaceAll("\\s+", "").startsWith("#")) {
            }
            String[] parts = line.replaceAll("\\s+", "").split(",");
            while ((check = bufferedReader.readLine()) != null) {
                if (check.replaceAll("\\s+", "").isEmpty()) continue;
                throw new IllegalArgumentException("invalid transport version file format [" + TransportVersion.toComponentPath(component, path) + "]");
            }
            if (parts.length < (nameInFile ? 2 : 1)) {
                throw new IllegalStateException("invalid transport version file format [" + TransportVersion.toComponentPath(component, path) + "]");
            }
            String name = null;
            if (isNamed) {
                name = nameInFile ? parts[0] : path.substring(path.lastIndexOf(47) + 1, path.length() - 4);
            }
            ArrayList<Integer> ids = new ArrayList<Integer>();
            int n = i = nameInFile ? 1 : 0;
            while (i < parts.length) {
                try {
                    ids.add(Integer.parseInt(parts[i]));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalStateException("invalid transport version file format [" + TransportVersion.toComponentPath(component, path) + "]", nfe);
                }
                ++i;
            }
            TransportVersion transportVersion = null;
            for (int idIndex = ids.size() - 1; idIndex >= 0; --idIndex) {
                if (idIndex > 0 && (Integer)ids.get(idIndex - 1) <= (Integer)ids.get(idIndex)) {
                    throw new IllegalStateException("invalid transport version file format [" + TransportVersion.toComponentPath(component, path) + "]");
                }
                if ((Integer)ids.get(idIndex) > upperBound) break;
                transportVersion = new TransportVersion(name, (Integer)ids.get(idIndex), transportVersion);
            }
            return transportVersion;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("invalid transport version file format [" + TransportVersion.toComponentPath(component, path) + "]", ioe);
        }
    }

    public static List<TransportVersion> collectFromResources(String component, String resourceRoot, Function<String, InputStream> resourceLoader, String upperBoundFileName) {
        List versionRelativePaths;
        TransportVersion upperBound = TransportVersion.parseFromBufferedReader(component, resourceRoot + "/upper_bounds/" + upperBoundFileName, resourceLoader, (c, p, br) -> TransportVersion.fromBufferedReader(c, p, true, false, br, Integer.MAX_VALUE));
        if (upperBound != null && (versionRelativePaths = TransportVersion.parseFromBufferedReader(component, resourceRoot + "/definitions/manifest.txt", resourceLoader, (c, p, br) -> br.lines().filter(line -> !line.isBlank()).toList())) != null) {
            ArrayList<TransportVersion> transportVersions = new ArrayList<TransportVersion>();
            for (String versionRelativePath : versionRelativePaths) {
                TransportVersion transportVersion = TransportVersion.parseFromBufferedReader(component, resourceRoot + "/definitions/" + versionRelativePath, resourceLoader, (c, p, br) -> TransportVersion.fromBufferedReader(c, p, false, versionRelativePath.startsWith("referable/"), br, upperBound.id()));
                if (transportVersion == null) continue;
                transportVersions.add(transportVersion);
            }
            return transportVersions;
        }
        return List.of();
    }

    private static String toComponentPath(String component, String path) {
        return component + ":" + path;
    }

    public static TransportVersion readVersion(StreamInput in) throws IOException {
        return TransportVersion.fromId(in.readVInt());
    }

    public static TransportVersion fromId(int id) {
        TransportVersion known = VersionsHolder.ALL_VERSIONS_BY_ID.get(id);
        if (known != null) {
            return known;
        }
        return new TransportVersion(id);
    }

    public static TransportVersion fromName(String name) {
        TransportVersion known = VersionsHolder.ALL_VERSIONS_BY_NAME.get(name);
        if (known == null) {
            LevenshteinDistance ld = new LevenshteinDistance();
            ArrayList<Tuple<Float, String>> scoredNames = new ArrayList<Tuple<Float, String>>();
            for (String key : VersionsHolder.ALL_VERSIONS_BY_NAME.keySet()) {
                float distance = ld.getDistance(name, key);
                if (!(distance > 0.7f)) continue;
                scoredNames.add(new Tuple<Float, String>(Float.valueOf(distance), key));
            }
            StringBuilder message = new StringBuilder("Unknown transport version [");
            message.append(name);
            message.append("].");
            if (!scoredNames.isEmpty()) {
                List<String> names = scoredNames.stream().map(Tuple::v2).toList();
                message.append(" Did you mean ");
                message.append(names);
                message.append("?");
            }
            message.append(" If this is a new transport version, run './gradle generateTransportVersion'.");
            throw new IllegalStateException(message.toString());
        }
        return known;
    }

    public static void writeVersion(TransportVersion version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static TransportVersion min(TransportVersion version1, TransportVersion version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static TransportVersion max(TransportVersion version1, TransportVersion version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static boolean isCompatible(TransportVersion version) {
        return version.onOrAfter(VersionsHolder.MINIMUM_COMPATIBLE);
    }

    public static TransportVersion current() {
        return VersionsHolder.CURRENT;
    }

    public static TransportVersion zero() {
        return VersionsHolder.ZERO;
    }

    public static TransportVersion minimumCompatible() {
        return VersionsHolder.MINIMUM_COMPATIBLE;
    }

    public static TransportVersion minimumCCSVersion() {
        return VersionsHolder.MINIMUM_CCS_VERSION;
    }

    public static List<TransportVersion> getAllVersions() {
        return VersionsHolder.ALL_VERSIONS;
    }

    public boolean isKnown() {
        return VersionsHolder.ALL_VERSIONS_BY_ID.containsKey(this.id);
    }

    public TransportVersion bestKnownVersion() {
        if (this.isKnown()) {
            return this;
        }
        TransportVersion bestSoFar = VersionsHolder.ZERO;
        for (TransportVersion knownVersion : VersionsHolder.ALL_VERSIONS_BY_ID.values()) {
            if (!knownVersion.after(bestSoFar) || !knownVersion.before(this)) continue;
            bestSoFar = knownVersion;
        }
        return bestSoFar;
    }

    public static TransportVersion fromString(String str) {
        return TransportVersion.fromId(Integer.parseInt(str));
    }

    public boolean isPatchFrom(TransportVersion version) {
        return this.onOrAfter(version) && this.id < version.id + 100 - version.id % 100;
    }

    public boolean supports(TransportVersion version) {
        if (this.onOrAfter(version)) {
            return true;
        }
        TransportVersion nextPatchVersion = version.nextPatchVersion;
        while (nextPatchVersion != null) {
            if (this.isPatchFrom(nextPatchVersion)) {
                return true;
            }
            nextPatchVersion = nextPatchVersion.nextPatchVersion;
        }
        return false;
    }

    public String toReleaseVersion() {
        return VersionsHolder.VERSION_LOOKUP_BY_RELEASE.apply(this.id);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportVersion that = (TransportVersion)o;
        return this.id == that.id;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public String toString() {
        return Integer.toString(this.id);
    }

    static interface BufferedReaderParser<T> {
        public T parse(String var1, String var2, BufferedReader var3);
    }

    private static class VersionsHolder {
        private static final List<TransportVersion> ALL_VERSIONS;
        private static final Map<Integer, TransportVersion> ALL_VERSIONS_BY_ID;
        private static final Map<String, TransportVersion> ALL_VERSIONS_BY_NAME;
        private static final IntFunction<String> VERSION_LOOKUP_BY_RELEASE;
        private static final TransportVersion CURRENT;
        private static final TransportVersion ZERO;
        private static final TransportVersion MINIMUM_COMPATIBLE;
        private static final TransportVersion MINIMUM_CCS_VERSION;

        private VersionsHolder() {
        }

        private static TransportVersion loadConstant(String name) {
            return TransportVersion.parseFromBufferedReader("<server>", "/transport/constants/" + name + ".csv", TransportVersion.class::getResourceAsStream, (c, p, br) -> TransportVersion.fromBufferedReader(c, p, false, false, br, Integer.MAX_VALUE));
        }

        private static List<TransportVersion> addTransportVersions(Collection<TransportVersion> addFrom, List<TransportVersion> addTo) {
            for (TransportVersion transportVersion : addFrom) {
                addTo.add(transportVersion);
                for (TransportVersion patchVersion = transportVersion.nextPatchVersion(); patchVersion != null; patchVersion = patchVersion.nextPatchVersion()) {
                    addTo.add(patchVersion);
                }
            }
            return addTo;
        }

        static {
            ArrayList<TransportVersion> allVersions = new ArrayList<TransportVersion>(TransportVersions.DEFINED_VERSIONS);
            List<TransportVersion> streamVersions = TransportVersion.collectFromResources("<server>", "/transport", TransportVersion.class::getResourceAsStream, Version.CURRENT.major + "." + Version.CURRENT.minor + ".csv");
            Map<String, TransportVersion> allVersionsByName = streamVersions.stream().filter(tv -> tv.name() != null).collect(Collectors.toMap(TransportVersion::name, v -> v));
            VersionsHolder.addTransportVersions(streamVersions, allVersions).sort(VersionId::compareTo);
            VERSION_LOOKUP_BY_RELEASE = ReleaseVersions.generateVersionsLookup(TransportVersions.class, ((TransportVersion)allVersions.get(allVersions.size() - 1)).id());
            Collection extendedVersions = ExtensionLoader.loadSingleton(ServiceLoader.load(VersionExtension.class)).map(VersionExtension::getTransportVersions).orElse(Collections.emptyList());
            VersionsHolder.addTransportVersions(extendedVersions, allVersions).sort(VersionId::compareTo);
            for (TransportVersion version : extendedVersions) {
                if (version.name() == null) continue;
                allVersionsByName.put(version.name(), version);
            }
            ALL_VERSIONS = Collections.unmodifiableList(allVersions);
            ALL_VERSIONS_BY_ID = ALL_VERSIONS.stream().collect(Collectors.toUnmodifiableMap(TransportVersion::id, Function.identity()));
            ALL_VERSIONS_BY_NAME = Collections.unmodifiableMap(allVersionsByName);
            CURRENT = ALL_VERSIONS.getLast();
            ZERO = new TransportVersion(0);
            MINIMUM_COMPATIBLE = VersionsHolder.loadConstant("minimum_compatible");
            MINIMUM_CCS_VERSION = VersionsHolder.loadConstant("minimum_ccs_version");
        }
    }
}

