/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jruby.embed.ScriptingContainer;

public class RakeTaskBase
extends Task {
    private Object rakeWrapper;
    private ScriptingContainer container;
    protected String filename;

    public RakeTaskBase() {
        this.acquireRakeReference();
    }

    public void setFile(String filename2) {
        this.filename = filename2;
    }

    public void execute() throws BuildException {
        this.container.put("$project", this.getProject());
    }

    protected void acquireRakeReference() {
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            System.setProperty("jruby.native.enabled", "false");
            this.container = new ScriptingContainer();
            this.container.setLoadPaths(Arrays.asList("lib"));
            this.container.runScriptlet("require 'ant/tasks/raketasks'");
            this.rakeWrapper = this.container.runScriptlet("RakeWrapper.new");
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
    }

    protected List handleFilenameArgument() {
        ArrayList<String> args2 = new ArrayList<String>();
        if (this.filename != null) {
            args2.add("-f");
            args2.add(this.filename);
        }
        return args2;
    }

    public void rakeMethod(String method2, Object ... args2) throws BuildException {
        try {
            this.container.callMethod(this.rakeWrapper, method2, args2);
        }
        catch (Exception e) {
            throw new BuildException("Build failed: " + e.getMessage(), (Throwable)e);
        }
    }
}

