/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;

public final class QueryApiKeyResponse
extends ActionResponse
implements ToXContentObject {
    public static final QueryApiKeyResponse EMPTY = new QueryApiKeyResponse(0L, List.of(), List.of(), null, null);
    private final long total;
    private final List<Item> foundApiKeyInfoList;
    @Nullable
    private final InternalAggregations aggregations;

    public QueryApiKeyResponse(long total, Collection<ApiKey> foundApiKeysInfos, Collection<Object[]> sortValues, @Nullable Collection<String> ownerProfileUids, @Nullable InternalAggregations aggregations) {
        Iterator<String> profileUidIterator;
        this.total = total;
        Objects.requireNonNull(foundApiKeysInfos, "found_api_keys_infos must be provided");
        Objects.requireNonNull(sortValues, "sort_values must be provided");
        if (foundApiKeysInfos.size() != sortValues.size()) {
            throw new IllegalStateException("Each api key info must be associated to a (nullable) sort value");
        }
        if (ownerProfileUids != null && foundApiKeysInfos.size() != ownerProfileUids.size()) {
            throw new IllegalStateException("Each api key info must be associated to a (nullable) owner profile uid");
        }
        int size = foundApiKeysInfos.size();
        this.foundApiKeyInfoList = new ArrayList<Item>(size);
        Iterator<ApiKey> apiKeyIterator = foundApiKeysInfos.iterator();
        Iterator<Object[]> sortValueIterator = sortValues.iterator();
        Iterator<String> iterator = profileUidIterator = ownerProfileUids != null ? ownerProfileUids.iterator() : null;
        while (apiKeyIterator.hasNext()) {
            if (!sortValueIterator.hasNext()) {
                throw new IllegalStateException("Each api key info must be associated to a (nullable) sort value");
            }
            if (profileUidIterator != null && !profileUidIterator.hasNext()) {
                throw new IllegalStateException("Each api key info must be associated to a (nullable) owner profile uid");
            }
            this.foundApiKeyInfoList.add(new Item(apiKeyIterator.next(), sortValueIterator.next(), profileUidIterator != null ? profileUidIterator.next() : null));
        }
        this.aggregations = aggregations;
    }

    public long getTotal() {
        return this.total;
    }

    public List<Item> getApiKeyInfoList() {
        return this.foundApiKeyInfoList;
    }

    public InternalAggregations getAggregations() {
        return this.aggregations;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("total", this.total).field("count", this.foundApiKeyInfoList.size()).field("api_keys", (Iterable<?>)this.foundApiKeyInfoList);
        if (this.aggregations != null) {
            this.aggregations.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryApiKeyResponse that = (QueryApiKeyResponse)o;
        return this.total == that.total && Objects.equals(this.foundApiKeyInfoList, that.foundApiKeyInfoList) && Objects.equals(this.aggregations, that.aggregations);
    }

    public int hashCode() {
        int result = Objects.hash(this.total);
        result = 31 * result + Objects.hash(this.foundApiKeyInfoList);
        result = 31 * result + Objects.hash(this.aggregations);
        return result;
    }

    public String toString() {
        return "QueryApiKeyResponse{total=" + this.total + ", items=" + String.valueOf(this.foundApiKeyInfoList) + ", aggs=" + String.valueOf(this.aggregations) + "}";
    }

    public record Item(ApiKey apiKeyInfo, @Nullable Object[] sortValues, @Nullable String ownerProfileUid) implements ToXContentObject
    {
        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.apiKeyInfo.innerToXContent(builder, params);
            if (this.sortValues != null && this.sortValues.length > 0) {
                builder.array("_sort", this.sortValues);
            }
            if (this.ownerProfileUid != null) {
                builder.field("profile_uid", this.ownerProfileUid);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return "Item{apiKeyInfo=" + String.valueOf(this.apiKeyInfo) + ", sortValues=" + Arrays.toString(this.sortValues) + ", ownerProfileUid=" + this.ownerProfileUid + "}";
        }
    }
}

