/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shards;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class IndicesShardStoresResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private final Map<String, Map<Integer, List<StoreStatus>>> storeStatuses;
    private final List<Failure> failures;

    public IndicesShardStoresResponse(Map<String, Map<Integer, List<StoreStatus>>> storeStatuses, List<Failure> failures) {
        this.storeStatuses = storeStatuses;
        this.failures = failures;
    }

    public IndicesShardStoresResponse(StreamInput in) throws IOException {
        this.storeStatuses = in.readImmutableMap(i -> i.readImmutableMap(StreamInput::readInt, j -> j.readCollectionAsImmutableList(StoreStatus::new)));
        this.failures = in.readCollectionAsImmutableList(Failure::readFailure);
    }

    public Map<String, Map<Integer, List<StoreStatus>>> getStoreStatuses() {
        return this.storeStatuses;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.storeStatuses, (o, v) -> o.writeMap(v, StreamOutput::writeInt, StreamOutput::writeCollection));
        out.writeCollection(this.failures);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        return Iterators.concat(ChunkedToXContentHelper.startObject(), this.failures.isEmpty() ? Collections.emptyIterator() : ChunkedToXContentHelper.array("failures", this.failures.iterator()), ChunkedToXContentHelper.startObject("indices"), Iterators.flatMap(this.storeStatuses.entrySet().iterator(), indexShards -> Iterators.concat(ChunkedToXContentHelper.startObject((String)indexShards.getKey()), ChunkedToXContentHelper.startObject("shards"), Iterators.map(((Map)indexShards.getValue()).entrySet().iterator(), shardStatusesEntry -> (builder, params) -> {
            builder.startObject(String.valueOf(shardStatusesEntry.getKey())).startArray("stores");
            for (StoreStatus storeStatus : (List)shardStatusesEntry.getValue()) {
                builder.startObject();
                storeStatus.toXContent(builder, params);
                builder.endObject();
            }
            return builder.endArray().endObject();
        }), ChunkedToXContentHelper.endObject(), ChunkedToXContentHelper.endObject())), ChunkedToXContentHelper.endObject(), ChunkedToXContentHelper.endObject());
    }

    static final class Fields {
        static final String INDICES = "indices";
        static final String SHARDS = "shards";
        static final String FAILURES = "failures";
        static final String STORES = "stores";
        static final String ALLOCATION_ID = "allocation_id";
        static final String STORE_EXCEPTION = "store_exception";
        static final String ALLOCATED = "allocation";

        Fields() {
        }
    }

    public static class StoreStatus
    implements Writeable,
    ToXContentFragment,
    Comparable<StoreStatus> {
        private final DiscoveryNode node;
        private final String allocationId;
        private Exception storeException;
        private final AllocationStatus allocationStatus;

        public StoreStatus(StreamInput in) throws IOException {
            this.node = new DiscoveryNode(in);
            this.allocationId = in.readOptionalString();
            this.allocationStatus = AllocationStatus.readFrom(in);
            if (in.readBoolean()) {
                this.storeException = in.readException();
            }
        }

        public StoreStatus(DiscoveryNode node, String allocationId, AllocationStatus allocationStatus, Exception storeException) {
            this.node = node;
            this.allocationId = allocationId;
            this.allocationStatus = allocationStatus;
            this.storeException = storeException;
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public String getAllocationId() {
            return this.allocationId;
        }

        public Exception getStoreException() {
            return this.storeException;
        }

        public AllocationStatus getAllocationStatus() {
            return this.allocationStatus;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.node.writeTo(out);
            out.writeOptionalString(this.allocationId);
            this.allocationStatus.writeTo(out);
            if (this.storeException != null) {
                out.writeBoolean(true);
                out.writeException(this.storeException);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.node.toXContent(builder, params);
            if (this.allocationId != null) {
                builder.field("allocation_id", this.allocationId);
            }
            builder.field("allocation", this.allocationStatus.value());
            if (this.storeException != null) {
                builder.startObject("store_exception");
                ElasticsearchException.generateThrowableXContent(builder, params, this.storeException);
                builder.endObject();
            }
            return builder;
        }

        @Override
        public int compareTo(StoreStatus other) {
            if (this.storeException != null && other.storeException == null) {
                return 1;
            }
            if (other.storeException != null && this.storeException == null) {
                return -1;
            }
            if (this.allocationId != null && other.allocationId == null) {
                return -1;
            }
            if (this.allocationId == null && other.allocationId != null) {
                return 1;
            }
            if (this.allocationId == null && other.allocationId == null) {
                return Integer.compare(this.allocationStatus.id, other.allocationStatus.id);
            }
            int compare = Integer.compare(this.allocationStatus.id, other.allocationStatus.id);
            if (compare == 0) {
                return this.allocationId.compareTo(other.allocationId);
            }
            return compare;
        }

        public static enum AllocationStatus {
            PRIMARY(0),
            REPLICA(1),
            UNUSED(2);

            private final byte id;

            private AllocationStatus(byte id) {
                this.id = id;
            }

            private static AllocationStatus fromId(byte id) {
                return switch (id) {
                    case 0 -> PRIMARY;
                    case 1 -> REPLICA;
                    case 2 -> UNUSED;
                    default -> throw new IllegalArgumentException("unknown id for allocation status [" + id + "]");
                };
            }

            public String value() {
                return switch (this.id) {
                    case 0 -> "primary";
                    case 1 -> "replica";
                    case 2 -> "unused";
                    default -> throw new IllegalArgumentException("unknown id for allocation status [" + this.id + "]");
                };
            }

            private static AllocationStatus readFrom(StreamInput in) throws IOException {
                return AllocationStatus.fromId(in.readByte());
            }

            private void writeTo(StreamOutput out) throws IOException {
                out.writeByte(this.id);
            }
        }
    }

    public static class Failure
    extends DefaultShardOperationFailedException {
        private final String nodeId;

        public Failure(String nodeId, String index, int shardId, Throwable reason) {
            super(index, shardId, reason);
            this.nodeId = nodeId;
        }

        private Failure(StreamInput in) throws IOException {
            Failure.readFrom(in, this);
            this.nodeId = in.readString();
        }

        public String nodeId() {
            return this.nodeId;
        }

        static Failure readFailure(StreamInput in) throws IOException {
            return new Failure(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.nodeId);
        }

        @Override
        public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("node", this.nodeId());
            return super.innerToXContent(builder, params);
        }
    }
}

