"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rateLimiterConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const rateLimiterConfigSchema = exports.rateLimiterConfigSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  elu: _configSchema.schema.conditional(_configSchema.schema.siblingRef('enabled'), false, _configSchema.schema.never(), _configSchema.schema.number({
    min: 0,
    max: 1
  })),
  term: _configSchema.schema.conditional(_configSchema.schema.siblingRef('enabled'), false, _configSchema.schema.never(), _configSchema.schema.oneOf([_configSchema.schema.literal('short'), _configSchema.schema.literal('medium'), _configSchema.schema.literal('long')], {
    defaultValue: 'long'
  }))
});