"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncRulesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _searchConnectors = require("@kbn/search-connectors");
var _public = require("@kbn/kibana-react-plugin/public");
var _translations = require("../../translations");
var _index_view_logic = require("../../index_view_logic");
var _connector_filtering_logic = require("./connector_filtering_logic");
var _doc_links = require("../../../shared/doc_links");
var _inline_editable_table_logic = require("../../../shared/tables/inline_editable_table/inline_editable_table_logic");
var _inline_editable_table = require("../../../shared/tables/inline_editable_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/search_index/connector/sync_rules/editable_basic_rules_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const instanceId = 'FilteringRulesTable';
function validateItem(filteringRule) {
  if (filteringRule.rule === 'regex') {
    try {
      new RegExp(filteringRule.value);
      return {};
    } catch {
      return {
        value: _translations.REGEX_ERROR
      };
    }
  }
  return {};
}
const SyncRulesTable = () => {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    editableFilteringRules
  } = (0, _kea.useValues)((0, _connector_filtering_logic.ConnectorFilteringLogic)({
    http
  }));
  const {
    indexName
  } = (0, _kea.useValues)((0, _index_view_logic.IndexViewLogic)({
    http
  }));
  const {
    addFilteringRule,
    deleteFilteringRule,
    reorderFilteringRules,
    updateFilteringRule
  } = (0, _kea.useActions)((0, _connector_filtering_logic.ConnectorFilteringLogic)({
    http
  }));
  const description = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, (0, _translations.getSyncRulesDescription)(indexName), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.syncRules,
    external: true,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, _translations.SYNC_RULES_LEARN_MORE_LINK));
  const columns = [{
    editingRender: (filteringRule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      fullWidth: true,
      value: filteringRule.policy,
      onChange: e => onChange(e.target.value),
      options: [{
        text: (0, _searchConnectors.filteringPolicyToText)('include'),
        value: 'include'
      }, {
        text: (0, _searchConnectors.filteringPolicyToText)('exclude'),
        value: 'exclude'
      }],
      "aria-label": _translations.BASIC_TABLE_POLICY_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }),
    field: 'policy',
    name: _translations.BASIC_TABLE_POLICY_TITLE,
    render: indexingRule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }, (0, _searchConnectors.filteringPolicyToText)(indexingRule.policy))
  }, {
    editingRender: (rule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: rule.field,
      onChange: e => onChange(e.target.value),
      "aria-label": _translations.BASIC_TABLE_FIELD_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 13
      }
    }))),
    field: 'field',
    name: _translations.BASIC_TABLE_FIELD_TITLE,
    render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 11
      }
    }, rule.field))
  }, {
    editingRender: (filteringRule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      fullWidth: true,
      value: filteringRule.rule,
      onChange: e => onChange(e.target.value),
      options: Object.values(_searchConnectors.FilteringRuleRuleValues).map(rule => ({
        text: (0, _searchConnectors.filteringRuleToText)(rule),
        value: rule
      })),
      "aria-label": _translations.BASIC_TABLE_RULE_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 9
      }
    }),
    field: 'rule',
    name: _translations.BASIC_TABLE_RULE_TITLE,
    render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 30
      }
    }, (0, _searchConnectors.filteringRuleToText)(rule.rule))
  }, {
    editingRender: (rule, onChange) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: rule.value,
      onChange: e => onChange(e.target.value),
      "aria-label": _translations.BASIC_TABLE_VALUE_TITLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 13
      }
    }))),
    field: 'value',
    name: _translations.BASIC_TABLE_VALUE_TITLE,
    render: rule => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }, rule.value))
  }];
  return /*#__PURE__*/_react.default.createElement(_inline_editable_table.InlineEditableTable, {
    addButtonText: _translations.SYNC_RULES_TABLE_ADD_RULE_LABEL,
    ariaLabel: _translations.SYNC_RULES_TABLE_ARIA_LABEL,
    columns: columns,
    defaultItem: {
      policy: 'include',
      rule: 'equals',
      value: ''
    },
    description: description,
    instanceId: instanceId,
    items: editableFilteringRules,
    onAdd: rule => {
      const now = new Date().toISOString();
      const newRule = {
        ...rule,
        created_at: now,
        // crypto.randomUUID isn't widely enough available in browsers yet
        id: (0, _uuid.v4)(),
        updated_at: now
      };
      addFilteringRule(newRule);
      (0, _inline_editable_table_logic.InlineEditableTableLogic)({
        instanceId
      }).actions.doneEditing();
    },
    onDelete: deleteFilteringRule,
    onUpdate: rule => {
      updateFilteringRule(rule);
      (0, _inline_editable_table_logic.InlineEditableTableLogic)({
        instanceId
      }).actions.doneEditing();
    },
    onReorder: reorderFilteringRules,
    title: "",
    validateItem: validateItem,
    bottomRows: [/*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 20
      }
    }, _translations.INCLUDE_EVERYTHING_ELSE_MESSAGE)],
    canRemoveLastItem: true,
    emptyPropertyAllowed: true,
    showRowIndex: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 5
    }
  });
};
exports.SyncRulesTable = SyncRulesTable;