"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColumnsPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/columns_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ColumnsPopover = ({
  selectedColumns,
  onSelectedColumnsChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(prevValue => !prevValue), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const [columnSearchText, setColumnSearchText] = (0, _react.useState)('');
  const isDragEnabled = columnSearchText.length === 0;
  const toggleColumns = (0, _react.useCallback)(({
    isChecked,
    field
  }) => {
    const newSelectedColumns = selectedColumns.map(column => {
      if (column.field === field || !field) {
        return {
          ...column,
          isChecked
        };
      }
      return column;
    });
    onSelectedColumnsChange(newSelectedColumns);
  }, [selectedColumns, onSelectedColumnsChange]);
  const showAll = (0, _react.useCallback)(() => toggleColumns({
    isChecked: true
  }), [toggleColumns]);
  const hideAll = (0, _react.useCallback)(() => toggleColumns({
    isChecked: false
  }), [toggleColumns]);
  const onDragEnd = ({
    source,
    destination
  }) => {
    if (source && destination) {
      const reorderedColumns = (0, _eui.euiDragDropReorder)(selectedColumns, source.index, destination.index);
      onSelectedColumnsChange(reorderedColumns);
    }
  };
  const filteredColumns = (0, _react.useMemo)(() => selectedColumns.filter(({
    name
  }) => name.toLowerCase().indexOf(columnSearchText.toLowerCase()) !== -1), [selectedColumns, columnSearchText]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "s",
    anchorPosition: "leftUp",
    zIndex: 0,
    "data-test-subj": "column-selection-popover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": i18n.COLUMNS,
      className: "columns",
      "data-test-subj": "column-selection-popover-button",
      iconType: "indexOpen",
      iconSide: "left",
      onClick: togglePopover,
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 9
      }
    }, i18n.COLUMNS),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    compressed: true,
    placeholder: i18n.SEARCH,
    "aria-label": i18n.SEARCH_COLUMNS,
    value: columnSearchText,
    onChange: e => setColumnSearchText(e.currentTarget.value),
    "data-test-subj": "column-selection-popover-search",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEnd,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
            width: 300px;
            height: 40vh;
          `,
    className: "eui-yScrollWithShadows",
    "data-test-subj": "column-selection-popover-drag-drop-context",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: "casesColumnDroppableArea",
    css: isDragEnabled ? {
      paddingBottom: euiTheme.size.base
    } : {
      paddingTop: euiTheme.size.base
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, filteredColumns.map(({
    field,
    name,
    isChecked
  }, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    key: field,
    index: idx,
    draggableId: field,
    isDragDisabled: !isDragEnabled,
    css: {
      height: euiTheme.size.xl,
      paddingLeft: euiTheme.size.base
    },
    customDragHandle: true,
    hasInteractiveChildren: true,
    usePortal: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 17
    }
  }, provided => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: columnSearchText,
      title: name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 29
      }
    }, name),
    checked: isChecked,
    "data-test-subj": `column-selection-switch-${field}`,
    onChange: e => toggleColumns({
      field,
      isChecked: e.target.checked
    }),
    compressed: true,
    labelProps: {
      style: {
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap',
        width: '190px',
        overflow: 'hidden'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 25
    }
  })), isDragEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "column-selection-popover-draggable-icon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    color: "transparent"
  }, provided.dragHandleProps, {
    "aria-label": i18n.DRAG_HANDLE,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 27
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grab",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 29
    }
  })))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "left",
    onClick: showAll,
    "data-test-subj": "column-selection-popover-show-all-button",
    disabled: !isDragEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 13
    }
  }, i18n.SHOW_ALL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    onClick: hideAll,
    "data-test-subj": "column-selection-popover-hide-all-button",
    disabled: !isDragEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 13
    }
  }, i18n.HIDE_ALL)))));
};
exports.ColumnsPopover = ColumnsPopover;
ColumnsPopover.displayName = 'ColumnsPopover';