"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OTelDetails = OTelDetails;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/service_icons/otel_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function OTelDetails({
  opentelemetry
}) {
  if (!opentelemetry) {
    return null;
  }
  const listItems = [];
  listItems.push({
    title: _i18n.i18n.translate('xpack.apm.serviceIcons.otelDetails.opentelemetry.language', {
      defaultMessage: 'Language'
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!opentelemetry.language ? opentelemetry.language : 'unknown')
  });
  if (!!opentelemetry.sdkVersion) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.otelDetails.opentelemetry.sdkVersion', {
        defaultMessage: 'OTel SDK version'
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, opentelemetry.sdkVersion)
    });
  }
  if (!!opentelemetry.autoVersion) {
    listItems.push({
      title: _i18n.i18n.translate('xpack.apm.serviceIcons.otelDetails.opentelemetry.autoVersion', {
        defaultMessage: 'Auto instrumentation agent version'
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, opentelemetry.autoVersion)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse",
    listItems: listItems,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 10
    }
  });
}