"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrashDetailLink = CrashDetailLink;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_apm_router = require("../../../../../hooks/use_apm_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/apm/mobile/crash_detail_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function CrashDetailLink({
  serviceName,
  groupId,
  query,
  ...rest
}) {
  const router = (0, _use_apm_router.useApmRouter)();
  const crashDetailsLink = router.link(`/mobile-services/{serviceName}/errors-and-crashes/crashes/{groupId}`, {
    path: {
      serviceName,
      groupId
    },
    query
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "apmMobileCrashDetailsLink",
    href: crashDetailsLink
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 10
    }
  }));
}