"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _constants = require("@kbn/aiops-common/constants");
var _dataService = require("@kbn/data-service");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _change_point_detection_context = require("../components/change_point_detection/change_point_detection_context");
var _embeddable_chart_component_wrapper = require("../embeddables/change_point_chart/embeddable_chart_component_wrapper");
var _use_aiops_app_context = require("../hooks/use_aiops_app_context");
var _use_data_source = require("../hooks/use_data_source");
var _use_filters_query = require("../hooks/use_filters_query");
var _use_reload = require("../hooks/use_reload");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/shared_components/change_point_detection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Only used to initialize internally
 */

const ChangePointDetectionWrapper = ({
  // Component dependencies
  coreStart,
  pluginStart,
  // Component props
  viewType,
  dataViewId,
  fn,
  metricField,
  splitField,
  partitions,
  maxSeriesToPlot,
  timeRange,
  onLoading,
  onError,
  onRenderComplete,
  embeddingOrigin,
  lastReloadRequestTime,
  filtersApi
}) => {
  const deps = (0, _react2.useMemo)(() => {
    const {
      charts,
      lens,
      data,
      usageCollection,
      fieldFormats,
      share,
      storage,
      unifiedSearch
    } = pluginStart;
    return {
      charts,
      data,
      lens,
      usageCollection,
      fieldFormats,
      unifiedSearch,
      share,
      storage,
      ...coreStart
    };
  }, [coreStart, pluginStart]);
  const datePickerDeps = {
    ...(0, _lodash.pick)(deps, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'userProfile', 'i18n']),
    uiSettingsKeys: _dataService.UI_SETTINGS
  };
  const aiopsAppContextValue = (0, _react2.useMemo)(() => {
    return {
      embeddingOrigin: embeddingOrigin !== null && embeddingOrigin !== void 0 ? embeddingOrigin : _constants.AIOPS_EMBEDDABLE_ORIGIN.DEFAULT,
      ...deps
    };
  }, [deps, embeddingOrigin]);
  const [manualReload$] = (0, _react2.useState)(new _rxjs.BehaviorSubject(lastReloadRequestTime !== null && lastReloadRequestTime !== void 0 ? lastReloadRequestTime : Date.now()));
  (0, _react2.useEffect)(function updateManualReloadSubject() {
    if (!lastReloadRequestTime) return;
    manualReload$.next(lastReloadRequestTime);
  }, [lastReloadRequestTime, manualReload$]);
  const resultObservable$ = (0, _react2.useMemo)(() => {
    return (0, _rxjs.combineLatest)([manualReload$]).pipe((0, _rxjs.map)(([manualReload]) => Math.max(manualReload)), (0, _rxjs.distinctUntilChanged)());
  }, [manualReload$]);

  // TODO: Remove data-shared-item as part of https://github.com/elastic/kibana/issues/179376>
  return /*#__PURE__*/_react2.default.createElement("div", {
    "data-shared-item": "",
    "data-test-subj": "aiopsEmbeddableChangePointChart",
    css: (0, _react.css)`
        width: 100%;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
    value: aiopsAppContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_mlDatePicker.DatePickerContextProvider, (0, _extends2.default)({}, datePickerDeps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react2.default.createElement(_use_reload.ReloadContextProvider, {
    reload$: resultObservable$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_use_data_source.DataSourceContextProvider, {
    dataViews: pluginStart.data.dataViews,
    dataViewId: dataViewId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_use_filters_query.FilterQueryContextProvider, {
    timeRange: timeRange,
    filtersApi: filtersApi,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_change_point_detection_context.ChangePointDetectionControlsContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_embeddable_chart_component_wrapper.ChartGridEmbeddableWrapper, {
    viewType: viewType,
    timeRange: timeRange,
    fn: fn,
    metricField: metricField,
    splitField: splitField,
    maxSeriesToPlot: maxSeriesToPlot,
    dataViewId: dataViewId,
    partitions: partitions,
    onLoading: onLoading,
    onRenderComplete: onRenderComplete,
    onError: onError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 19
    }
  }))))))));
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = ChangePointDetectionWrapper;
module.exports = exports.default;