"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiKeyPadMenuItemStyles = exports.euiKeyPadMenuItemChildStyles = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _accessibility = require("../accessibility");
var _key_pad_menu = require("./key_pad_menu.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiKeyPadMenuItemStyles = exports.euiKeyPadMenuItemStyles = function euiKeyPadMenuItemStyles(euiThemeContext) {
  var _euiTheme$flags;
  var euiTheme = euiThemeContext.euiTheme;
  var _euiKeyPadMenuVariabl = (0, _key_pad_menu.euiKeyPadMenuVariables)(euiThemeContext),
    euiKeyPadMenuSize = _euiKeyPadMenuVariabl.euiKeyPadMenuSize;
  var hasVisColorAdjustment = (_euiTheme$flags = euiTheme.flags) === null || _euiTheme$flags === void 0 ? void 0 : _euiTheme$flags.hasVisColorAdjustment;
  var focusTransformStyles = "\n    ".concat((0, _euiThemeCommon.euiShadow)(euiThemeContext, 's'), ";\n\n    ").concat(_global_styling.euiCanAnimate, " {\n      .euiKeyPadMenuItem__icon {\n        transform: translateY(0);\n      }\n    }\n  ");
  return {
    euiKeyPadMenuItem: /*#__PURE__*/(0, _react.css)("display:block;padding:", euiTheme.size.xs, ";", (0, _global_styling.logicalSizeCSS)(euiKeyPadMenuSize), " border-radius:", euiTheme.border.radius.medium, ";color:", euiTheme.colors.textParagraph, ";", _global_styling.euiCanAnimate, "{transition:background-color ", euiTheme.animation.fast, " ease-in,box-shadow ", euiTheme.animation.fast, " ease-in;};label:euiKeyPadMenuItem;"),
    enabled: /*#__PURE__*/(0, _react.css)("&:is(:hover, :focus, :focus-within){cursor:pointer;text-decoration:underline;", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      // Use `outline` instead of border to avoid affecting absolutely positioned children
      preferred: "\n            outline: ".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.primary, ";\n          ")
    }), " ", hasVisColorAdjustment ? focusTransformStyles : "background-color: ".concat(euiTheme.colors.backgroundBaseInteractiveHover), ";}&:focus{box-shadow:none;background-color:", hasVisColorAdjustment ? euiTheme.focus.backgroundColor : euiTheme.colors.backgroundBaseInteractiveHover, ";};label:enabled;"),
    selected: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.textHeading, ";background-color:", hasVisColorAdjustment ? euiTheme.focus.backgroundColor : '', ";&:is(*, :hover, :focus, :focus-within){color:", euiTheme.colors.textPrimary, ";background-color:", !hasVisColorAdjustment ? euiTheme.colors.backgroundBaseInteractiveSelect : '', ";", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      // Skip checkable items (which render a <label> instead of <button>/<a>),
      // as they already have sufficient indication of state (checkbox or radio)
      preferred: "\n            &:not(label) {\n              outline: ".concat(euiTheme.border.width.thick, " solid ").concat(euiTheme.colors.primary, ";\n              outline-offset: 0;\n            }\n          ")
    }), ";};label:selected;"),
    disabled: {
      disabled: /*#__PURE__*/(0, _react.css)("cursor:not-allowed;color:", euiTheme.colors.textDisabled, ";", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
        none: "\n            .euiKeyPadMenuItem__icon {\n              filter: ".concat(hasVisColorAdjustment ? 'grayscale(100%)' : '', ";\n\n              svg * {\n                fill: ").concat(euiTheme.colors.textDisabled, ";\n              }\n            }\n          "),
        forced: 'opacity: 0.5;'
      }), ";;label:disabled;"),
      selected: /*#__PURE__*/(0, _react.css)("background-color:", hasVisColorAdjustment ? euiTheme.components.keyPadMenuItemBackgroundDisabledSelect : euiTheme.colors.backgroundBaseDisabled, ";", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
        preferred: "\n            &:not(label) {\n              outline: ".concat(euiTheme.border.width.thick, " solid ").concat(euiTheme.colors.textDisabled, ";\n            }\n          ")
      }), ";;label:selected;")
    }
  };
};
var euiKeyPadMenuItemChildStyles = exports.euiKeyPadMenuItemChildStyles = function euiKeyPadMenuItemChildStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var topRightChildren = "\n    z-index: 3;\n    position: absolute;\n    ".concat((0, _global_styling.logicalCSS)('top', euiTheme.size.xs), "\n    ").concat((0, _global_styling.logicalCSS)('right', euiTheme.size.xs), "\n  ");
  return {
    euiKeyPadMenuItem__inner: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalSizeCSS)('100%'), " display:flex;flex-direction:column;align-items:center;justify-content:center;position:relative;;label:euiKeyPadMenuItem__inner;"),
    euiKeyPadMenuItem__icon: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.m), " transform:translateY(2px);", _global_styling.euiCanAnimate, "{transition:transform ", euiTheme.animation.normal, " ", euiTheme.animation.bounce, ";};label:euiKeyPadMenuItem__icon;"),
    euiKeyPadMenuItem__label: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), " font-weight:", euiTheme.font.weight.semiBold, ";text-align:center;;label:euiKeyPadMenuItem__label;"),
    euiKeyPadMenuItem__betaBadge: /*#__PURE__*/(0, _react.css)(topRightChildren, ";;label:euiKeyPadMenuItem__betaBadge;"),
    euiKeyPadMenuItem__checkableInput: /*#__PURE__*/(0, _react.css)("position:absolute;", topRightChildren, " transform:scale(.75);transform-origin:top right;;label:euiKeyPadMenuItem__checkableInput;"),
    showCheckableInputOnInteraction: /*#__PURE__*/(0, _react.css)(".euiKeyPadMenuItem:not(:hover, :focus, :focus-within) &{", (0, _accessibility.euiScreenReaderOnly)(), ";};label:showCheckableInputOnInteraction;"),
    hideCheckableInput: /*#__PURE__*/(0, _react.css)((0, _accessibility.euiScreenReaderOnly)(), ";;label:hideCheckableInput;")
  };
};