"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationActionsMenu = IntegrationActionsMenu;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/details/integration_actions_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const integrationActionsText = _i18n.i18n.translate('xpack.datasetQuality.details.integrationActionsText', {
  defaultMessage: 'Integration actions'
});
const seeIntegrationText = _i18n.i18n.translate('xpack.datasetQuality.details.seeIntegrationActionText', {
  defaultMessage: 'See integration'
});
const indexTemplateText = _i18n.i18n.translate('xpack.datasetQuality.details.indexTemplateActionText', {
  defaultMessage: 'Index template'
});
const viewDashboardsText = _i18n.i18n.translate('xpack.datasetQuality.details.viewDashboardsActionText', {
  defaultMessage: 'View dashboards'
});
function IntegrationActionsMenu({
  integration,
  dashboards,
  dashboardsLoading
}) {
  const {
    canUserAccessDashboards,
    canUserViewIntegrations,
    datasetDetails
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    version,
    name: integrationName
  } = integration;
  const {
    type,
    name
  } = datasetDetails;
  const {
    isOpen,
    handleCloseMenu,
    handleToggleMenu,
    getIntegrationOverviewLinkProps,
    getIndexManagementLinkProps,
    getDashboardLinkProps
  } = (0, _hooks.useIntegrationActions)();
  const actionButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    title: integrationActionsText,
    "aria-label": integrationActionsText,
    iconType: "boxesHorizontal",
    onClick: handleToggleMenu,
    "data-test-subj": "datasetQualityDetailsIntegrationActionsButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  });
  const MenuActionItem = ({
    dataTestSubject,
    buttonText,
    routerLinkProps,
    iconType,
    disabled = false
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, routerLinkProps, {
    size: "s",
    css: (0, _react2.css)`
        font-weight: normal;
      `,
    color: "text",
    iconType: iconType,
    "data-test-subj": dataTestSubject,
    disabled: disabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }), buttonText);
  const panelItems = (0, _react.useMemo)(() => {
    const firstLevelItems = [...(canUserViewIntegrations ? [{
      renderItem: () => /*#__PURE__*/_react.default.createElement(MenuActionItem, {
        buttonText: seeIntegrationText,
        dataTestSubject: "datasetQualityDetailsIntegrationActionOverview",
        routerLinkProps: getIntegrationOverviewLinkProps(integrationName, version),
        iconType: "package",
        disabled: !canUserViewIntegrations,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 112,
          columnNumber: 17
        }
      })
    }] : []), {
      renderItem: () => /*#__PURE__*/_react.default.createElement(MenuActionItem, {
        buttonText: indexTemplateText,
        dataTestSubject: "datasetQualityDetailsIntegrationActionTemplate",
        routerLinkProps: getIndexManagementLinkProps({
          sectionId: 'data',
          appId: `index_management/templates/${type}-${name}`
        }),
        iconType: "indexPatternApp",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 11
        }
      })
    }, {
      isSeparator: true,
      key: 'sep'
    }];
    if (dashboards !== null && dashboards !== void 0 && dashboards.length && canUserAccessDashboards) {
      firstLevelItems.push({
        icon: 'dashboardApp',
        panel: 1,
        name: viewDashboardsText,
        'data-test-subj': 'datasetQualityDetailsIntegrationActionViewDashboards',
        disabled: false
      });
    } else if (dashboardsLoading) {
      firstLevelItems.push({
        icon: 'dashboardApp',
        name: /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
          width: 120,
          title: viewDashboardsText,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 153,
            columnNumber: 15
          }
        }),
        'data-test-subj': 'datasetQualityDetailsIntegrationActionDashboardsLoading',
        disabled: true
      });
    }
    const panel = [{
      id: 0,
      items: firstLevelItems
    }, {
      id: 1,
      title: viewDashboardsText,
      items: dashboards === null || dashboards === void 0 ? void 0 : dashboards.map(dashboard => {
        return {
          renderItem: () => /*#__PURE__*/_react.default.createElement(MenuActionItem, {
            buttonText: dashboard.title,
            dataTestSubject: "datasetQualityDetailsIntegrationActionDashboard",
            routerLinkProps: getDashboardLinkProps(dashboard),
            iconType: "dashboardApp",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 170,
              columnNumber: 15
            }
          })
        };
      })
    }];
    return panel;
  }, [dashboards, getDashboardLinkProps, getIndexManagementLinkProps, getIntegrationOverviewLinkProps, integrationName, name, type, version, dashboardsLoading, canUserAccessDashboards, canUserViewIntegrations]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    panelPaddingSize: "none",
    button: actionButton,
    isOpen: isOpen,
    closePopover: handleCloseMenu,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    size: "s",
    panels: panelItems,
    initialPanelId: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }));
}