"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegesWarningIconWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/common/insufficient_privileges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const insufficientPrivilegesText = _i18n.i18n.translate('xpack.datasetQuality.insufficientPrivilegesMessage', {
  defaultMessage: "You don't have sufficient privileges to access this information."
});

// @ts-ignore // TODO: Add link to Dataset Quality permissions documentation
const LearnMoreLink = () => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  "data-test-subj": "datasetQualityMissingPrivilegesLink",
  target: "_blank",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.insufficientPrivilegesLearnMore",
  defaultMessage: "Learn more",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 5
  }
}));
const PrivilegesWarningIconWrapper = ({
  hasPrivileges,
  title,
  mode = 'popover',
  iconColor = 'warning',
  popoverCss,
  children
}) => {
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  const handleButtonClick = togglePopover;
  if (hasPrivileges) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }
  return mode === 'popover' ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    css: popoverCss,
    attachToAnchor: true,
    anchorPosition: "downCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `datasetQualityInsufficientPrivileges-${title}`,
      "aria-label": insufficientPrivilegesText,
      title: insufficientPrivilegesText,
      iconType: "warning",
      color: iconColor,
      onClick: handleButtonClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, insufficientPrivilegesText, " ") : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: insufficientPrivilegesText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "data-test-subj": `datasetQualityInsufficientPrivileges-${title}`,
    "aria-label": insufficientPrivilegesText,
    title: insufficientPrivilegesText,
    type: "warning",
    color: iconColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }), children));
};
exports.PrivilegesWarningIconWrapper = PrivilegesWarningIconWrapper;