"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldPreviewHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _state_utils = require("../../state_utils");
var _field_editor_context = require("../field_editor_context");
var _field_preview_context = require("./field_preview_context");
var _is_updating_indicator = require("./is_updating_indicator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/preview/field_preview_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const i18nTexts = {
  title: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.title', {
    defaultMessage: 'Preview'
  }),
  customData: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.subTitle.customData', {
    defaultMessage: 'Custom data'
  })
};
const isLoadingSelector = state => state.isLoadingDocuments;
const documentSourceSelector = state => state.documentSource;
const FieldPreviewHeader = () => {
  const {
    dataView
  } = (0, _field_editor_context.useFieldEditorContext)();
  const {
    controller
  } = (0, _field_preview_context.useFieldPreviewContext)();
  const isFetchingDocument = (0, _state_utils.useStateSelector)(controller.state$, isLoadingSelector);
  const documentSource = (0, _state_utils.useStateSelector)(controller.state$, documentSourceSelector);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 13
    }
  }, i18nTexts.title))), isFetchingDocument && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "isFetchingDocumentIndicator",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_is_updating_indicator.IsUpdatingIndicator, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    "data-test-subj": "subTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.subTitle', {
    defaultMessage: 'From: {documentSource}',
    values: {
      documentSource: documentSource === 'cluster' ? dataView.getIndexPattern() : i18nTexts.customData
    }
  }))));
};
exports.FieldPreviewHeader = FieldPreviewHeader;