"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypeField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-views-plugin/public");
var _rollup = require("@kbn/rollup");
var _shared_imports = require("../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/components/form_fields/type_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const standardSelectItem = /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  css: {
    whiteSpace: 'nowrap'
  },
  "data-test-subj": "standardType",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.standardTitle",
  defaultMessage: "Standard data view",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 7
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.standardDescription",
  defaultMessage: "Perform full aggregations against any data",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 7
  }
})));
const rollupSelectItem = /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
  css: {
    whiteSpace: 'nowrap'
  },
  "data-test-subj": "rollupType",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.rollupTitle",
  defaultMessage: "Rollup data view",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 7
  }
}), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: _uiTheme.euiLightVars.euiColorAccent,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 59,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.betaLabel",
  defaultMessage: "Beta",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 9
  }
})), "\xA0", /*#__PURE__*/_react.default.createElement(_rollup.RollupDeprecationTooltip, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  color: "warning",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.deprecatedBadge",
  defaultMessage: "Deprecated",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 11
  }
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 72,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.typeSelect.rollupDescription",
  defaultMessage: "Perform limited aggregations against summarized data",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 7
  }
})));
const TypeField = ({
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, ({
    label,
    value,
    setValue
  }) => {
    if (value === undefined) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      "data-test-subj": "typeField",
      options: [{
        value: _public.INDEX_PATTERN_TYPE.DEFAULT,
        inputDisplay: _i18n.i18n.translate('indexPatternEditor.typeSelect.standard', {
          defaultMessage: 'Standard'
        }),
        dropdownDisplay: standardSelectItem
      }, {
        value: _public.INDEX_PATTERN_TYPE.ROLLUP,
        inputDisplay: _i18n.i18n.translate('indexPatternEditor.typeSelect.rollup', {
          defaultMessage: 'Rollup (deprecated)'
        }),
        dropdownDisplay: rollupSelectItem
      }],
      valueOfSelected: value,
      onChange: newValue => {
        setValue(newValue);
        onChange(newValue);
      },
      "aria-label": _i18n.i18n.translate('indexPatternEditor.editor.form.typeSelectAriaLabel', {
        defaultMessage: 'Type field'
      }),
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 15
      }
    })));
  });
};
exports.TypeField = TypeField;