"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecondaryMenuSectionComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/secondary_menu/section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * To reflect the design perfectly while maintaining a logical structure,
 * we need to use `6px` and `10px` which are not multiples of 4, hence why
 * `euiTheme` is not used for padding here.
 *
 * Furthermore, `236px` is not available in `euiTheme` as a constant,
 * so we use it directly.
 *
 * `EuiTitle` provides styles inconsistent with design, and `EuiText` doesn't allow
 * `h5` usage so semantically, the structure could use improvement.
 */
const SecondaryMenuSectionComponent = ({
  children,
  label
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const sectionId = label ? label.replace(/\s+/g, '-').toLowerCase() : undefined;
  return /*#__PURE__*/_react.default.createElement("nav", {
    css: (0, _react2.css)`
        padding: ${euiTheme.size.m};

        &:not(:last-child) {
          border-bottom: 1px ${euiTheme.colors.borderBaseSubdued} solid;
        }
      `,
    "aria-labelledby": sectionId || undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, label && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    id: sectionId,
    css: (0, _react2.css)`
            font-size: ${euiTheme.size.m};
            color: ${euiTheme.colors.subduedText};
            // 6px comes from Figma, no token
            padding: 6px ${euiTheme.size.s};
          `,
    component: "span",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, label), /*#__PURE__*/_react.default.createElement("ul", {
    css: (0, _react2.css)`
          display: flex;
          flex-direction: column;
          width: 100%;
          gap: ${euiTheme.size.xxs};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, children));
};
exports.SecondaryMenuSectionComponent = SecondaryMenuSectionComponent;