"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _crypto_service = require("./crypto_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CasesService {
  constructor() {
    (0, _defineProperty2.default)(this, "cryptoService", void 0);
    this.cryptoService = new _crypto_service.CryptoService();
  }
  getCaseId({
    ruleId,
    spaceId,
    owner,
    grouping,
    counter
  }) {
    if (grouping == null && ruleId == null) {
      throw new Error('ruleID or grouping is required');
    }
    const payload = [ruleId, spaceId, owner, this.cryptoService.stringifyDeterministically(grouping), counter].filter(Boolean).join(':');
    return this.cryptoService.getHash(payload);
  }
}
exports.CasesService = CasesService;