"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = void 0;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reducer = (state, action) => {
  switch (action.type) {
    case _types.ActionType.RESET:
      return {
        phase: _types.UploadPhase.IDLE
      };
    case _types.ActionType.START_UPLOAD:
      return {
        phase: _types.UploadPhase.START_UPLOAD,
        filename: action.filename,
        placeholder: action.placeholder
      };
    case _types.ActionType.UPLOAD_IN_PROGRESS:
      return {
        phase: _types.UploadPhase.UPLOADING,
        filename: action.filename,
        placeholder: action.placeholder
      };
    case _types.ActionType.UPLOAD_FINISHED:
      return {
        phase: _types.UploadPhase.FINISHED,
        file: action.file,
        placeholder: action.placeholder
      };
    case _types.ActionType.UPLOAD_ERROR:
      return {
        phase: _types.UploadPhase.ERROR,
        errors: action.errors
      };
    default:
      return state;
  }
};
exports.reducer = reducer;