"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Assignees = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _userProfileComponents = require("@kbn/user-profile-components");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _constants = require("../../../common/constants");
var _use_suggest_user_profiles = require("../../containers/user_profiles/use_suggest_user_profiles");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_get_current_user_profile = require("../../containers/user_profiles/use_get_current_user_profile");
var _optional_field_label = require("../optional_field_label");
var i18n = _interopRequireWildcard(require("../create/translations"));
var _sort = require("../user_profiles/sort");
var _use_available_owners = require("../app/use_available_owners");
var _permissions = require("../../utils/permissions");
var _use_is_user_typing = require("../../common/use_is_user_typing");
var _use_bulk_get_user_profiles = require("../../containers/user_profiles/use_bulk_get_user_profiles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/case_form_fields/assignees.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FIELD_ID = 'assignees';
const getConfig = () => ({
  label: i18n.ASSIGNEES,
  defaultValue: [],
  validations: [{
    validator: ({
      value
    }) => {
      if (value.length > _constants.MAX_ASSIGNEES_PER_CASE) {
        return {
          message: i18n.INVALID_ASSIGNEES
        };
      }
    }
  }]
});
const userProfileToComboBoxOption = userProfile => ({
  label: (0, _userProfileComponents.getUserDisplayName)(userProfile.user),
  value: userProfile.uid,
  key: userProfile.uid,
  user: userProfile.user,
  data: userProfile.data
});
const comboBoxOptionToAssignee = option => {
  var _option$value;
  return {
    uid: (_option$value = option.value) !== null && _option$value !== void 0 ? _option$value : ''
  };
};
const AssigneesFieldComponent = /*#__PURE__*/_react.default.memo(({
  field,
  isLoading,
  isDisabled,
  options,
  currentUserProfile,
  onSearchComboChange
}) => {
  const {
    setValue,
    value: selectedAssignees
  } = field;
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const selectedOptions = selectedAssignees.map(({
    uid
  }) => {
    const selectedUserProfile = options.find(userProfile => userProfile.key === uid);
    if (selectedUserProfile) {
      return selectedUserProfile;
    }
    return null;
  }).filter(value => value != null);
  const onComboChange = (0, _react.useCallback)(currentOptions => {
    setValue(currentOptions.map(option => comboBoxOptionToAssignee(option)));
  }, [setValue]);
  const onSelfAssign = (0, _react.useCallback)(() => {
    if (!currentUserProfile) {
      return;
    }
    setValue([...selectedAssignees, {
      uid: currentUserProfile.uid
    }]);
  }, [currentUserProfile, selectedAssignees, setValue]);
  const renderOption = (0, _react.useCallback)((option, searchValue, contentClassName) => {
    const {
      user,
      data
    } = option;
    const displayName = (0, _userProfileComponents.getUserDisplayName)(user);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexStart",
      gutterSize: "s",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
      user: user,
      avatar: data.avatar,
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween",
      gutterSize: "none",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      className: contentClassName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    }, displayName)), user.email && user.email !== displayName ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: 'subdued',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      className: contentClassName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 21
      }
    }, user.email))) : null));
  }, []);
  const isCurrentUserSelected = Boolean(selectedAssignees === null || selectedAssignees === void 0 ? void 0 : selectedAssignees.find(assignee => assignee.uid === (currentUserProfile === null || currentUserProfile === void 0 ? void 0 : currentUserProfile.uid)));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "createCaseAssignees",
    fullWidth: true,
    label: i18n.ASSIGNEES,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    helpText: currentUserProfile ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "create-case-assign-yourself-link",
      onClick: onSelfAssign,
      disabled: isCurrentUserSelected,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 13
      }
    }, i18n.ASSIGN_YOURSELF) : undefined,
    isInvalid: isInvalid,
    error: errorMessage,
    "data-test-subj": "caseAssignees",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: isInvalid,
    fullWidth: true,
    async: true,
    isLoading: isLoading,
    options: options,
    "data-test-subj": "createCaseAssigneesComboBox",
    selectedOptions: selectedOptions,
    isDisabled: isDisabled,
    onChange: onComboChange,
    onSearchChange: onSearchComboChange,
    renderOption: renderOption,
    rowHeight: 35,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }));
});
AssigneesFieldComponent.displayName = 'AssigneesFieldComponent';
const AssigneesComponent = ({
  isLoading: isLoadingForm
}) => {
  var _bringCurrentUserToFr, _bringCurrentUserToFr2;
  const {
    owner: owners
  } = (0, _use_cases_context.useCasesContext)();
  const [{
    assignees
  }] = (0, _hook_form_lib.useFormData)({
    watch: [FIELD_ID]
  });
  const availableOwners = (0, _use_available_owners.useAvailableCasesOwners)((0, _permissions.getAllPermissionsExceptFrom)('delete'));
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const {
    isUserTyping,
    onContentChange,
    onDebounce
  } = (0, _use_is_user_typing.useIsUserTyping)();
  const hasOwners = owners.length > 0;
  const {
    data: currentUserProfile,
    isLoading: isLoadingCurrentUserProfile
  } = (0, _use_get_current_user_profile.useGetCurrentUserProfile)();
  const {
    data: userProfiles = [],
    isLoading: isLoadingSuggest,
    isFetching: isFetchingSuggest
  } = (0, _use_suggest_user_profiles.useSuggestUserProfiles)({
    name: searchTerm,
    owners: hasOwners ? owners : availableOwners,
    onDebounce
  });
  const assigneesWithoutProfiles = (0, _lodash.differenceWith)(assignees !== null && assignees !== void 0 ? assignees : [], userProfiles !== null && userProfiles !== void 0 ? userProfiles : [], (assignee, userProfile) => assignee.uid === userProfile.uid);
  const {
    data: bulkUserProfiles = new Map(),
    isFetching: isLoadingBulkGetUserProfiles
  } = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids: assigneesWithoutProfiles.map(assignee => assignee.uid)
  });
  const bulkUserProfilesAsArray = Array.from(bulkUserProfiles).map(([_, profile]) => profile);
  const options = (_bringCurrentUserToFr = (_bringCurrentUserToFr2 = (0, _sort.bringCurrentUserToFrontAndSort)(currentUserProfile, [...userProfiles, ...bulkUserProfilesAsArray])) === null || _bringCurrentUserToFr2 === void 0 ? void 0 : _bringCurrentUserToFr2.map(userProfile => userProfileToComboBoxOption(userProfile))) !== null && _bringCurrentUserToFr !== void 0 ? _bringCurrentUserToFr : [];
  const onSearchComboChange = value => {
    if (!(0, _lodash.isEmpty)(value)) {
      setSearchTerm(value);
    }
    onContentChange(value);
  };
  const isLoading = isLoadingForm || isLoadingCurrentUserProfile || isLoadingBulkGetUserProfiles || isLoadingSuggest || isFetchingSuggest || isUserTyping;
  const isDisabled = isLoadingForm || isLoadingCurrentUserProfile || isLoadingBulkGetUserProfiles;
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: FIELD_ID,
    config: getConfig(),
    component: AssigneesFieldComponent,
    componentProps: {
      isLoading,
      isDisabled,
      options,
      onSearchComboChange,
      currentUserProfile,
      isUserTyping
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 5
    }
  });
};
AssigneesComponent.displayName = 'AssigneesComponent';
const Assignees = exports.Assignees = /*#__PURE__*/(0, _react.memo)(AssigneesComponent);