"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FiltersGroup = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _filter = require("../../lib/filter");
var _filter2 = require("./filter.component");
var _filter_views = require("./filter_views");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_filters/filters_group.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const panelStyle = {
  paddingTop: '15px'
};
const FiltersGroup = ({
  filtersGroup,
  id
}) => {
  const {
    name,
    filters: groupFilters
  } = filtersGroup;
  const filledFilterViews = groupFilters.map(filter => {
    var _filterViews$filter$t;
    const filterView = (_filterViews$filter$t = _filter_views.filterViews[filter.type]) !== null && _filterViews$filter$t !== void 0 ? _filterViews$filter$t : _filter_views.filterViews.default;
    return (0, _filter.createFilledFilterView)(filterView.view, filter);
  });
  const filtersComponents = filledFilterViews.map((filter, index) => /*#__PURE__*/_react.default.createElement(_filter2.Filter, {
    key: `filter-${name}-${index}`,
    filter: filter,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__expandable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `canvas-filter-group-${id}`,
    buttonContent: name,
    initialIsOpen: true,
    className: "canvasSidebar__accordion filtersSidebar__accordion",
    style: {
      marginLeft: '0px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: panelStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, filtersComponents)));
};
exports.FiltersGroup = FiltersGroup;