"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderWithFn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _services = require("../../services");
var _render_to_dom = require("../render_to_dom");
var _i18n = require("../../../i18n");
var _use_canvas_api = require("../hooks/use_canvas_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/render_with_fn/render_with_fn.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  RenderWithFn: strings
} = _i18n.ErrorStrings;
const style = {
  height: '100%',
  width: '100%'
};
const RenderWithFn = ({
  name: functionName,
  renderFn,
  reuseNode = false,
  handlers: incomingHandlers,
  config,
  width,
  height
}) => {
  const canvasApi = (0, _use_canvas_api.useCanvasApi)();
  const {
    error: onError
  } = (0, _services.useNotifyService)();
  const [domNode, setDomNode] = (0, _react.useState)(null);

  // Tells us if the component is attempting to re-render into a previously-populated render target.
  const firstRender = (0, _react.useRef)(true);
  // A reference to the node appended to the provided DOM node which is created and optionally replaced.
  const renderTarget = (0, _react.useRef)(null);
  // A reference to the handlers, as the renderFn may mutate them, (via onXYZ functions)
  const handlers = (0, _react.useRef)(incomingHandlers);

  // Reset the render target, the node appended to the DOM node provided by RenderToDOM.
  const resetRenderTarget = (0, _react.useCallback)(() => {
    if (!domNode) {
      return;
    }
    if (!firstRender.current) {
      handlers.current.destroy();
    }
    while (domNode.firstChild) {
      domNode.removeChild(domNode.firstChild);
    }
    const div = document.createElement('div');
    div.style.width = '100%';
    div.style.height = '100%';
    domNode.appendChild(div);
    renderTarget.current = div;
    firstRender.current = true;
  }, [domNode]);
  (0, _react.useEffect)(() => handlers.current.resize({
    height,
    width
  }), [height, width]);
  (0, _react.useEffect)(() => () => {
    handlers.current.destroy();
  }, []);
  const render = (0, _react.useCallback)(async () => {
    if (!(0, _lodash.isEqual)(handlers.current, incomingHandlers)) {
      handlers.current = incomingHandlers;
    }
    /**
     * we are creating a new react tree when we render the element, so we need to pass the current api as a prop
     * to the element rather than calling `useCanvasApi` directly
     */
    await renderFn(renderTarget.current, {
      ...config,
      canvasApi
    }, handlers.current);
  }, [renderTarget, config, renderFn, incomingHandlers, canvasApi]);
  (0, _react.useEffect)(() => {
    if (!domNode) {
      return;
    }
    if (!reuseNode || !renderTarget.current) {
      resetRenderTarget();
    }
    render().then(() => {
      firstRender.current = false;
    }).catch(err => {
      onError(err, {
        title: strings.getRenderErrorMessage(functionName)
      });
    });
  }, [domNode, functionName, onError, render, resetRenderTarget, reuseNode]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasWorkpad--element_render canvasRenderEl",
    style: style,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_render_to_dom.RenderToDom, {
    style: style,
    render: node => {
      setDomNode(node);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }));
};
exports.RenderWithFn = RenderWithFn;