"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Popover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/popover/popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class Popover extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: !!this.props.isOpen
    });
    (0, _defineProperty2.default)(this, "handleClick", () => {
      this.setState(state => ({
        isPopoverOpen: !state.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
  }
  componentDidMount() {
    if (this.props.isOpen) {
      this.setState({
        isPopoverOpen: true
      });
    }
  }
  render() {
    const {
      button,
      children,
      tooltip,
      tooltipPosition,
      ...rest
    } = this.props;
    const wrappedButton = handleClick => {
      // wrap button in tooltip, if tooltip text is provided
      if (!this.state.isPopoverOpen && tooltip && tooltip.length) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: tooltipPosition,
          content: tooltip,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 78,
            columnNumber: 11
          }
        }, button(handleClick));
      }
      return button(handleClick);
    };
    const appWrapper = document.querySelector('.kbnAppWrapper');
    const EuiPopoverAny = _eui.EuiPopover;
    return /*#__PURE__*/_react.default.createElement(EuiPopoverAny, (0, _extends2.default)({}, rest, {
      button: wrappedButton(this.handleClick),
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      container: appWrapper,
      hasArrow: false,
      offset: 10,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    }), children({
      closePopover: this.closePopover
    }));
  }
}
exports.Popover = Popover;
(0, _defineProperty2.default)(Popover, "propTypes", {
  isOpen: _propTypes.default.bool,
  ownFocus: _propTypes.default.bool,
  button: _propTypes.default.func.isRequired,
  children: _propTypes.default.func.isRequired,
  tooltip: _propTypes.default.string,
  tooltipPosition: _propTypes.default.oneOf(['top', 'bottom', 'left', 'right'])
});
(0, _defineProperty2.default)(Popover, "defaultProps", {
  isOpen: false,
  ownFocus: true,
  tooltip: '',
  tooltipPosition: 'top'
});