"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetPicker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/asset_picker/asset_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getAssetAltText: () => _i18n.i18n.translate('xpack.canvas.assetpicker.assetAltText', {
    defaultMessage: 'Asset thumbnail'
  })
};
class AssetPicker extends _react.PureComponent {
  componentDidMount() {
    const selectedAsset = document.getElementById('canvasAssetPicker__selectedAsset');
    if (selectedAsset) {
      selectedAsset.scrollIntoView();
    }
  }
  render() {
    const {
      assets,
      selected,
      onChange
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      id: "canvasAssetPicker",
      className: "canvasAssetPicker",
      gutterSize: "s",
      columns: 4,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, assets.map(asset => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: asset.id,
      id: asset.id === selected ? 'canvasAssetPicker__selectedAsset' : '',
      className: "canvasCheckered",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      className: `canvasAssetPicker__link`,
      disabled: asset.id === selected,
      onClick: () => onChange(asset),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      url: asset.value,
      alt: strings.getAssetAltText(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 15
      }
    }), asset.id === selected && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "canvasAssetPicker__selected",
      type: "checkInCircleFilled",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 17
      }
    })))));
  }
}
exports.AssetPicker = AssetPicker;
(0, _defineProperty2.default)(AssetPicker, "propTypes", {
  assets: _propTypes.default.array.isRequired,
  selected: _propTypes.default.string,
  onChange: _propTypes.default.func.isRequired
});