"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceDependencies = getServiceDependencies;
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
var _get_connection_stats = require("../../lib/connections/get_connection_stats");
var _get_connection_stats_items_with_relative_impact = require("../../lib/connections/get_connection_stats/get_connection_stats_items_with_relative_impact");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceDependenciesForTimeRange({
  apmEventClient,
  start,
  end,
  serviceName,
  numBuckets,
  environment,
  offset,
  randomSampler
}) {
  const {
    statsItems
  } = await (0, _get_connection_stats.getConnectionStats)({
    apmEventClient,
    start,
    end,
    numBuckets,
    filter: [{
      term: {
        [_apm.SERVICE_NAME]: serviceName
      }
    }, ...(0, _environment_query.environmentQuery)(environment)],
    offset,
    collapseBy: 'downstream',
    randomSampler
  });
  return (0, _get_connection_stats_items_with_relative_impact.getConnectionStatsItemsWithRelativeImpact)(statsItems);
}
async function getServiceDependencies(opts) {
  const {
    offset,
    ...sharedOptions
  } = opts;
  const [currentPeriod, previousPeriod] = await Promise.all([getServiceDependenciesForTimeRange(sharedOptions), ...(offset ? [getServiceDependenciesForTimeRange({
    ...sharedOptions,
    offset
  })] : [[]])]);
  return currentPeriod.map(item => {
    const {
      stats,
      ...rest
    } = item;
    const previousPeriodItem = previousPeriod.find(prevItem => item.location.id === prevItem.location.id);
    return {
      ...rest,
      currentStats: stats,
      previousStats: (previousPeriodItem === null || previousPeriodItem === void 0 ? void 0 : previousPeriodItem.stats) || null
    };
  });
}