"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatencyAggregationTypeSelect = LatencyAggregationTypeSelect;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _latency_aggregation_types = require("../../../../../common/latency_aggregation_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/latency_chart/latency_aggregation_type_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const options = [{
  value: _latency_aggregation_types.LatencyAggregationType.avg,
  text: 'Average'
}, {
  value: _latency_aggregation_types.LatencyAggregationType.p95,
  text: '95th percentile'
}, {
  value: _latency_aggregation_types.LatencyAggregationType.p99,
  text: '99th percentile'
}];
function LatencyAggregationTypeSelect({
  latencyAggregationType,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "apmLatencyChartSelect",
    compressed: true,
    "aria-label": _i18n.i18n.translate('xpack.apm.serviceOverview.latencyChartTitle.selector', {
      defaultMessage: 'Metric selector'
    }),
    prepend: _i18n.i18n.translate('xpack.apm.serviceOverview.latencyChartTitle.prepend', {
      defaultMessage: 'Metric'
    }),
    options: options,
    value: latencyAggregationType,
    onChange: nextOption => onChange(nextOption.target.value),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  });
}