"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.settingsRoute = void 0;
var _i18n = require("@kbn/i18n");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../../common/agent_configuration/constants");
var _environment_rt = require("../../../../common/environment_rt");
var _breadcrumb = require("../../app/breadcrumb");
var _agent_configurations = require("../../app/settings/agent_configurations");
var _agent_explorer = require("../../app/settings/agent_explorer");
var _agent_keys = require("../../app/settings/agent_keys");
var _anomaly_detection = require("../../app/settings/anomaly_detection");
var _apm_indices = require("../../app/settings/apm_indices");
var _custom_link = require("../../app/settings/custom_link");
var _general_settings = require("../../app/settings/general_settings");
var _schema = require("../../app/settings/schema");
var _settings_template = require("../templates/settings_template");
var _create_agent_configuration_route_view = require("./create_agent_configuration_route_view");
var _edit_agent_configuration_route_view = require("./edit_agent_configuration_route_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/settings/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function page({
  title,
  tab,
  element
}) {
  return {
    element: /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
      title: title,
      href: `/settings/${tab}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_settings_template.SettingsTemplate, {
      selectedTab: tab,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }, element))
  };
}
const settingsRoute = exports.settingsRoute = {
  '/settings': {
    element: /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
      href: "/settings",
      title: _i18n.i18n.translate('xpack.apm.views.listSettings.title', {
        defaultMessage: 'Settings'
      }),
      omitOnServerless: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    })),
    children: {
      '/settings/general-settings': page({
        title: _i18n.i18n.translate('xpack.apm.views.settings.generalSettings.title', {
          defaultMessage: 'General settings'
        }),
        element: /*#__PURE__*/_react.default.createElement(_general_settings.GeneralSettings, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 65,
            columnNumber: 18
          }
        }),
        tab: 'general-settings'
      }),
      '/settings/agent-configuration': page({
        tab: 'agent-configuration',
        title: _i18n.i18n.translate('xpack.apm.views.settings.agentConfiguration.title', {
          defaultMessage: 'Agent Configuration'
        }),
        element: /*#__PURE__*/_react.default.createElement(_agent_configurations.AgentConfigurations, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 18
          }
        })
      }),
      '/settings/agent-configuration/create': {
        ...page({
          title: _i18n.i18n.translate('xpack.apm.views.settings.createAgentConfiguration.title', {
            defaultMessage: 'Create Agent Configuration'
          }),
          tab: 'agent-configuration',
          element: /*#__PURE__*/_react.default.createElement(_create_agent_configuration_route_view.CreateAgentConfigurationRouteView, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 81,
              columnNumber: 20
            }
          })
        }),
        params: t.partial({
          query: t.partial({
            pageStep: _constants.agentConfigurationPageStepRt
          })
        })
      },
      '/settings/agent-configuration/edit': {
        ...page({
          title: _i18n.i18n.translate('xpack.apm.views.settings.editAgentConfiguration.title', {
            defaultMessage: 'Edit Agent Configuration'
          }),
          tab: 'agent-configuration',
          element: /*#__PURE__*/_react.default.createElement(_edit_agent_configuration_route_view.EditAgentConfigurationRouteView, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 95,
              columnNumber: 20
            }
          })
        }),
        params: t.partial({
          query: t.partial({
            environment: t.string,
            name: t.string,
            pageStep: _constants.agentConfigurationPageStepRt
          })
        })
      },
      '/settings/apm-indices': page({
        title: _i18n.i18n.translate('xpack.apm.views.settings.indices.title', {
          defaultMessage: 'Indices'
        }),
        tab: 'apm-indices',
        element: /*#__PURE__*/_react.default.createElement(_apm_indices.ApmIndices, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 110,
            columnNumber: 18
          }
        })
      }),
      '/settings/custom-links': page({
        title: _i18n.i18n.translate('xpack.apm.views.settings.customLink.title', {
          defaultMessage: 'Custom Links'
        }),
        tab: 'custom-links',
        element: /*#__PURE__*/_react.default.createElement(_custom_link.CustomLinkOverview, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 18
          }
        })
      }),
      '/settings/schema': page({
        title: _i18n.i18n.translate('xpack.apm.views.settings.schema.title', {
          defaultMessage: 'Schema'
        }),
        element: /*#__PURE__*/_react.default.createElement(_schema.Schema, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 123,
            columnNumber: 18
          }
        }),
        tab: 'schema'
      }),
      '/settings/anomaly-detection': page({
        title: _i18n.i18n.translate('xpack.apm.views.settings.anomalyDetection.title', {
          defaultMessage: 'Anomaly detection'
        }),
        element: /*#__PURE__*/_react.default.createElement(_anomaly_detection.AnomalyDetection, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 130,
            columnNumber: 18
          }
        }),
        tab: 'anomaly-detection'
      }),
      '/settings/agent-keys': page({
        title: _i18n.i18n.translate('xpack.apm.views.settings.agentKeys.title', {
          defaultMessage: 'Agent keys'
        }),
        element: /*#__PURE__*/_react.default.createElement(_agent_keys.AgentKeys, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 137,
            columnNumber: 18
          }
        }),
        tab: 'agent-keys'
      }),
      '/settings/agent-explorer': {
        ...page({
          title: _i18n.i18n.translate('xpack.apm.views.settings.agentExplorer.title', {
            defaultMessage: 'Agent explorer'
          }),
          element: /*#__PURE__*/_react.default.createElement(_agent_explorer.AgentExplorer, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 145,
              columnNumber: 20
            }
          }),
          tab: 'agent-explorer'
        }),
        params: t.type({
          query: t.intersection([_environment_rt.environmentRt, t.type({
            kuery: t.string,
            agentLanguage: t.string,
            serviceName: t.string
          })])
        })
      },
      '/settings': {
        element: /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: "/settings/general-settings",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 160,
            columnNumber: 18
          }
        })
      }
    }
  }
};