"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileLocationStats = MobileLocationStats;
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _apm = require("../../../../../../common/es_fields/apm");
var _i18n2 = require("../../../../../../common/i18n");
var _metric_item = require("./metric_item");
var _use_previous_period_text = require("../../../../../hooks/use_previous_period_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/service_overview/stats/location_stats.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const formatDifference = value => {
  return value > 0 ? '+' + value.toFixed(0) + '%' : value.toFixed(0) + '%';
};
const calculateDiffPercentageAndFormat = (currentValue, previousValue) => {
  if (currentValue && previousValue) {
    const diffPercentageValue = (currentValue - previousValue) / previousValue * 100;
    return formatDifference(diffPercentageValue);
  }
  return 0;
};
function MobileLocationStats({
  start,
  end,
  kuery,
  serviceName,
  offset,
  environment,
  comparisonEnabled
}) {
  var _currentPeriod$mostRe, _currentPeriod$mostRe2, _currentPeriod$mostCr, _currentPeriod$mostCr2, _currentPeriod$mostSe, _currentPeriod$mostSe2, _currentPeriod$mostLa, _currentPeriod$mostLa2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  const locationField = _apm.CLIENT_GEO_COUNTRY_NAME;
  const {
    data: locationStatsData,
    status: locationStatsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/mobile-services/{serviceName}/location/stats', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          environment,
          kuery,
          locationField,
          offset
        }
      }
    });
  }, [start, end, environment, kuery, serviceName, locationField, offset]);
  const getIcon = (0, _react.useCallback)(type => ({
    width = 20,
    height = 20,
    color
  }) => {
    return locationStatsStatus === _use_fetcher.FETCH_STATUS.LOADING ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: type,
      width: width,
      height: height,
      fill: color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    });
  }, [locationStatsStatus]);
  const loadingLocationStats = (0, _use_fetcher.isPending)(locationStatsStatus);
  const currentPeriod = locationStatsData === null || locationStatsData === void 0 ? void 0 : locationStatsData.currentPeriod;
  const previousPeriod = locationStatsData === null || locationStatsData === void 0 ? void 0 : locationStatsData.previousPeriod;
  const getComparisonValueFormatter = (0, _react.useCallback)(({
    currentPeriodValue,
    previousPeriodValue
  }) => {
    const comparisonDiffValue = calculateDiffPercentageAndFormat(currentPeriodValue, previousPeriodValue);
    if (comparisonDiffValue && comparisonEnabled) {
      return /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 11
        }
      }, currentPeriodValue, " (", comparisonDiffValue, " ", previousPeriodLabel, ")");
    }
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 14
      }
    }, currentPeriodValue ? `${currentPeriodValue}` : null);
  }, [comparisonEnabled, previousPeriodLabel]);
  const metrics = [{
    color: euiTheme.colors.lightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.location.metrics.http.requests.title', {
      defaultMessage: 'Most used in'
    }),
    extra: getComparisonValueFormatter({
      currentPeriodValue: currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostRequests.value,
      previousPeriodValue: previousPeriod === null || previousPeriod === void 0 ? void 0 : previousPeriod.mostRequests.value
    }),
    icon: getIcon('visBarHorizontal'),
    value: (_currentPeriod$mostRe = currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostRequests.location) !== null && _currentPeriod$mostRe !== void 0 ? _currentPeriod$mostRe : _i18n2.NOT_AVAILABLE_LABEL,
    trend: (_currentPeriod$mostRe2 = currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostRequests.timeseries) !== null && _currentPeriod$mostRe2 !== void 0 ? _currentPeriod$mostRe2 : [],
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.colors.lightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.location.metrics.mostCrashes', {
      defaultMessage: 'Most crashes'
    }),
    extra: getComparisonValueFormatter({
      currentPeriodValue: currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostCrashes.value,
      previousPeriodValue: previousPeriod === null || previousPeriod === void 0 ? void 0 : previousPeriod.mostCrashes.value
    }),
    icon: getIcon('bug'),
    value: (_currentPeriod$mostCr = currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostCrashes.location) !== null && _currentPeriod$mostCr !== void 0 ? _currentPeriod$mostCr : _i18n2.NOT_AVAILABLE_LABEL,
    trend: (_currentPeriod$mostCr2 = currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostCrashes.timeseries) !== null && _currentPeriod$mostCr2 !== void 0 ? _currentPeriod$mostCr2 : [],
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.colors.lightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.location.metrics.sessions', {
      defaultMessage: 'Most sessions'
    }),
    extra: getComparisonValueFormatter({
      currentPeriodValue: currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostSessions.value,
      previousPeriodValue: previousPeriod === null || previousPeriod === void 0 ? void 0 : previousPeriod.mostSessions.value
    }),
    icon: getIcon('timeslider'),
    value: (_currentPeriod$mostSe = currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostSessions.location) !== null && _currentPeriod$mostSe !== void 0 ? _currentPeriod$mostSe : _i18n2.NOT_AVAILABLE_LABEL,
    trend: (_currentPeriod$mostSe2 = currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostSessions.timeseries) !== null && _currentPeriod$mostSe2 !== void 0 ? _currentPeriod$mostSe2 : [],
    trendShape: _charts.MetricTrendShape.Area
  }, {
    color: euiTheme.colors.lightestShade,
    title: _i18n.i18n.translate('xpack.apm.mobile.location.metrics.launches', {
      defaultMessage: 'Most launches'
    }),
    extra: getComparisonValueFormatter({
      currentPeriodValue: currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostLaunches.value,
      previousPeriodValue: previousPeriod === null || previousPeriod === void 0 ? void 0 : previousPeriod.mostLaunches.value
    }),
    icon: getIcon('launch'),
    value: (_currentPeriod$mostLa = currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostLaunches.location) !== null && _currentPeriod$mostLa !== void 0 ? _currentPeriod$mostLa : _i18n2.NOT_AVAILABLE_LABEL,
    trend: (_currentPeriod$mostLa2 = currentPeriod === null || currentPeriod === void 0 ? void 0 : currentPeriod.mostLaunches.timeseries) !== null && _currentPeriod$mostLa2 !== void 0 ? _currentPeriod$mostLa2 : [],
    trendShape: _charts.MetricTrendShape.Area
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 5
    }
  }, metrics.map((metric, key) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: key,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_item.MetricItem, {
    id: key,
    data: [metric],
    isLoading: loadingLocationStats,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 11
    }
  }))));
}