"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_SAVED_OBJECT_TYPE = void 0;
exports.getGapsSummaryByRuleIds = getGapsSummaryByRuleIds;
var _pMap = _interopRequireDefault(require("p-map"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _esQuery = require("@kbn/es-query");
var _authorization = require("../../../../authorization");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _lib = require("../../../../lib");
var _rule = require("../../../../data/rule");
var _constants = require("../../../../rules_client/common/constants");
var _build_gaps_filter = require("../../../../lib/rule_gaps/build_gaps_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_SAVED_OBJECT_TYPE = exports.RULE_SAVED_OBJECT_TYPE = 'alert';
async function getGapsSummaryByRuleIds(context, params) {
  try {
    var _aggregations$alertTy, _aggs$aggregations, _uniqueRuleIdsAgg$buc;
    let authorizationTuple;
    try {
      authorizationTuple = await context.authorization.getFindAuthorizationFilter({
        authorizationEntity: _authorization.AlertingAuthorizationEntity.Rule,
        filterOpts: _constants.alertingAuthorizationFilterOpts
      });
    } catch (error) {
      var _context$auditLogger;
      (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
        action: _audit_events.RuleAuditAction.GET_GAPS_SUMMARY_BY_RULE_IDS,
        error
      }));
      throw error;
    }
    const {
      start,
      end,
      ruleIds
    } = params;
    const {
      filter: authorizationFilter
    } = authorizationTuple;
    const kueryNodeFilter = (0, _lib.convertRuleIdsToKueryNode)(ruleIds);
    const kueryNodeFilterWithAuth = authorizationFilter && kueryNodeFilter ? _esQuery.nodeBuilder.and([kueryNodeFilter, authorizationFilter]) : kueryNodeFilter;
    const eventLogClient = await context.getEventLogClient();
    const {
      aggregations
    } = await (0, _rule.findRulesSo)({
      savedObjectsClient: context.unsecuredSavedObjectsClient,
      savedObjectsFindOptions: {
        filter: kueryNodeFilterWithAuth,
        page: 1,
        perPage: 0,
        ...(context.namespace ? {
          namespaces: [context.namespace]
        } : undefined),
        aggs: {
          alertTypeId: {
            multi_terms: {
              terms: [{
                field: 'alert.attributes.alertTypeId'
              }, {
                field: 'alert.attributes.consumer'
              }]
            }
          }
        }
      }
    });
    const buckets = aggregations === null || aggregations === void 0 ? void 0 : (_aggregations$alertTy = aggregations.alertTypeId) === null || _aggregations$alertTy === void 0 ? void 0 : _aggregations$alertTy.buckets;
    if (buckets === undefined || !buckets.length) {
      throw _boom.default.badRequest(`No rules matching ids ${ruleIds} found to get gaps summary`);
    }
    await (0, _pMap.default)(buckets, async ({
      key: [ruleType, consumer]
    }) => {
      try {
        await context.authorization.ensureAuthorized({
          ruleTypeId: ruleType,
          consumer,
          operation: _authorization.ReadOperations.FindGaps,
          entity: _authorization.AlertingAuthorizationEntity.Rule
        });
      } catch (error) {
        var _context$auditLogger2;
        (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
          action: _audit_events.RuleAuditAction.GET_GAPS_SUMMARY_BY_RULE_IDS,
          error
        }));
        throw error;
      }
    }, {
      concurrency: _constants.RULE_TYPE_CHECKS_CONCURRENCY
    });
    const filter = (0, _build_gaps_filter.buildGapsFilter)({
      start,
      end
    });
    const aggs = await eventLogClient.aggregateEventsBySavedObjectIds(RULE_SAVED_OBJECT_TYPE, ruleIds, {
      filter,
      aggs: {
        unique_rule_ids: {
          terms: {
            field: 'rule.id',
            size: 10000
          },
          aggs: {
            totalUnfilledDurationMs: {
              sum: {
                field: 'kibana.alert.rule.gap.unfilled_duration_ms'
              }
            },
            totalInProgressDurationMs: {
              sum: {
                field: 'kibana.alert.rule.gap.in_progress_duration_ms'
              }
            },
            totalFilledDurationMs: {
              sum: {
                field: 'kibana.alert.rule.gap.filled_duration_ms'
              }
            }
          }
        }
      }
    });
    const uniqueRuleIdsAgg = (_aggs$aggregations = aggs.aggregations) === null || _aggs$aggregations === void 0 ? void 0 : _aggs$aggregations.unique_rule_ids;
    const resultBuckets = (_uniqueRuleIdsAgg$buc = uniqueRuleIdsAgg === null || uniqueRuleIdsAgg === void 0 ? void 0 : uniqueRuleIdsAgg.buckets) !== null && _uniqueRuleIdsAgg$buc !== void 0 ? _uniqueRuleIdsAgg$buc : [];
    const result = {
      data: resultBuckets.map(bucket => ({
        ruleId: bucket.key,
        totalUnfilledDurationMs: bucket.totalUnfilledDurationMs.value,
        totalInProgressDurationMs: bucket.totalInProgressDurationMs.value,
        totalFilledDurationMs: bucket.totalFilledDurationMs.value
      }))
    };
    return result;
  } catch (err) {
    const errorMessage = `Failed to find gaps summary for rules`;
    context.logger.error(`${errorMessage} - ${err}`);
    throw _boom.default.boomify(err, {
      message: errorMessage
    });
  }
}