"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertFromMaintenanceWindowToForm = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _rrule = require("@kbn/rrule");
var _lodash = require("lodash");
var _get_initial_by_weekday = require("@kbn/response-ops-recurring-schedule-form/utils/get_initial_by_weekday");
var _constants = require("@kbn/response-ops-recurring-schedule-form/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertFromMaintenanceWindowToForm = maintenanceWindow => {
  const startDate = maintenanceWindow.rRule.dtstart;
  const endDate = (0, _moment.default)(startDate).add(maintenanceWindow.duration);
  // maintenance window is considered recurring if interval is defined
  const recurring = (0, _lodash.has)(maintenanceWindow, 'rRule.interval');
  const form = {
    title: maintenanceWindow.title,
    startDate,
    endDate: endDate.toISOString(),
    timezone: [maintenanceWindow.rRule.tzid],
    recurring,
    scopedQuery: maintenanceWindow.scopedQuery
  };
  if (!recurring) return form;
  const rRule = maintenanceWindow.rRule;
  const isCustomFrequency = isCustom(rRule);
  const frequency = rRule.freq;
  const ends = rRule.until ? _constants.RecurrenceEnd.ON_DATE : rRule.count ? _constants.RecurrenceEnd.AFTER_X : _constants.RecurrenceEnd.NEVER;
  const recurringSchedule = {
    frequency: isCustomFrequency ? 'CUSTOM' : frequency,
    interval: rRule.interval,
    ends
  };
  if (isCustomFrequency) {
    recurringSchedule.customFrequency = frequency;
  }
  if (rRule.until) {
    recurringSchedule.until = rRule.until;
  }
  if (rRule.count) {
    recurringSchedule.count = rRule.count;
  }
  if (frequency !== _rrule.Frequency.MONTHLY && rRule.byweekday) {
    recurringSchedule.byweekday = (0, _get_initial_by_weekday.getInitialByWeekday)(rRule.byweekday, (0, _moment.default)(startDate));
  }
  if (frequency === _rrule.Frequency.MONTHLY) {
    if (rRule.byweekday) {
      recurringSchedule.bymonth = 'weekday';
    } else if (rRule.bymonthday) {
      recurringSchedule.bymonth = 'day';
    }
  }
  form.recurringSchedule = recurringSchedule;
  return form;
};
exports.convertFromMaintenanceWindowToForm = convertFromMaintenanceWindowToForm;
const isCustom = rRule => {
  const freq = rRule.freq;
  // interval is greater than 1
  if (rRule.interval && rRule.interval > 1) {
    return true;
  }
  // frequency is daily and no weekdays are selected
  if (freq && freq === _rrule.Frequency.DAILY && !rRule.byweekday) {
    return true;
  }
  // frequency is weekly and there are multiple weekdays selected
  if (freq && freq === _rrule.Frequency.WEEKLY && rRule.byweekday && rRule.byweekday.length > 1) {
    return true;
  }
  // frequency is monthly and by month day is selected
  if (freq && freq === _rrule.Frequency.MONTHLY && rRule.bymonthday) {
    return true;
  }
  return false;
};