"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveSingletonScopedBinding = resolveSingletonScopedBinding;
const cacheResolvedValue_1 = require("./cacheResolvedValue");
const resolveBindingActivations_1 = require("./resolveBindingActivations");
function resolveSingletonScopedBinding(resolve) {
    return (params, binding) => {
        if (binding.cache.isRight) {
            return binding.cache.value;
        }
        const resolvedValue = (0, resolveBindingActivations_1.resolveBindingActivations)(params, binding, resolve(params, binding));
        return (0, cacheResolvedValue_1.cacheResolvedValue)(binding, resolvedValue);
    };
}
//# sourceMappingURL=resolveSingletonScopedBinding.js.map