"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveInstanceBindingNodeFromConstructorParams = resolveInstanceBindingNodeFromConstructorParams;
const common_1 = require("@inversifyjs/common");
const resolvePostConstruct_1 = require("./resolvePostConstruct");
function resolveInstanceBindingNodeFromConstructorParams(setInstanceProperties) {
    return (constructorValues, params, node) => {
        const instance = new node.binding.implementationType(...constructorValues);
        const propertiesAssignmentResult = setInstanceProperties(params, instance, node);
        if ((0, common_1.isPromise)(propertiesAssignmentResult)) {
            return propertiesAssignmentResult.then(() => (0, resolvePostConstruct_1.resolvePostConstruct)(instance, node.binding, node.classMetadata.lifecycle.postConstructMethodName));
        }
        return (0, resolvePostConstruct_1.resolvePostConstruct)(instance, node.binding, node.classMetadata.lifecycle.postConstructMethodName);
    };
}
//# sourceMappingURL=resolveInstanceBindingNodeFromConstructorParams.js.map