"use strict";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getParsedVersion = getParsedVersion;
var tslib_1 = require("tslib");
function getParsedVersion(version) {
    var _a = tslib_1.__read(version.split('.'), 3), major = _a[0], minor = _a[1], patch = _a[2];
    return {
        version: version,
        version_major: parseInt(major, 10),
        version_minor: parseInt(minor, 10),
        version_patch: parseInt(patch, 10),
    };
}
