"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldMappingLimit = FieldMappingLimit;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../../../../../common/translations");
var _hooks = require("../../../../../../hooks");
var _increase_field_mapping_limit = require("./increase_field_mapping_limit");
var _field_limit_documentation_link = require("./field_limit_documentation_link");
var _message_callout = require("./message_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764072224118247846/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/quality_issue_flyout/degraded_field/possible_mitigations/field_limit/field_mapping_limit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FieldMappingLimit({
  areIntegrationAssetsAvailable
}) {
  var _degradedFieldAnalysi;
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: _translations.increaseFieldMappingLimitTitle
  });
  const {
    degradedFieldAnalysis
  } = (0, _hooks.useQualityIssues)();
  const accordionTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h6", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, _translations.increaseFieldMappingLimitTitle));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: accordionTitle,
    initialIsOpen: true,
    "data-test-subj": "datasetQualityDetailsDegradedFieldFlyoutFieldLimitMitigationAccordion",
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    component: "p",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, _translations.fieldLimitMitigationDescriptionText), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, _translations.fieldLimitMitigationConsiderationText), /*#__PURE__*/_react.default.createElement("ul", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }, _translations.fieldLimitMitigationConsiderationText1), /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, _translations.fieldLimitMitigationConsiderationText2), /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, _translations.fieldLimitMitigationConsiderationText3), /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  }, _translations.fieldLimitMitigationConsiderationText4))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }), areIntegrationAssetsAvailable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_increase_field_mapping_limit.IncreaseFieldMappingLimit, {
    totalFieldLimit: (_degradedFieldAnalysi = degradedFieldAnalysis === null || degradedFieldAnalysis === void 0 ? void 0 : degradedFieldAnalysis.totalFieldLimit) !== null && _degradedFieldAnalysi !== void 0 ? _degradedFieldAnalysi : 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_message_callout.MessageCallout, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_field_limit_documentation_link.FieldLimitDocLink, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  })));
}